/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.maven.gettext;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.xnap.commons.maven.gettext.AbstractGettextMojo;
import org.xnap.commons.maven.gettext.GettextUtils;
import org.xnap.commons.maven.gettext.LoggerStreamConsumer;

public class DistMojo
extends AbstractGettextMojo {
    protected String msgcatCmd;
    protected String msgfmtCmd;
    protected String targetBundle;
    protected String outputFormat;
    protected String javaVersion;
    protected String sourceLocale;

    public void execute() throws MojoExecutionException {
        this.outputDirectory.mkdirs();
        CommandlineFactory cf = null;
        if ("class".equals(this.outputFormat)) {
            cf = new MsgFmtCommandlineFactory();
        } else if ("properties".equals(this.outputFormat)) {
            cf = new MsgCatCommandlineFactory();
        } else {
            throw new MojoExecutionException("Unknown output format: " + this.outputFormat + ". Should be 'class' or 'properties'.");
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.poDirectory);
        ds.setIncludes(new String[]{"**/*.po"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            this.getLog().info((CharSequence)("Processing " + files[i]));
            File inputFile = new File(this.poDirectory, files[i]);
            File outputFile = cf.getOutputFile(inputFile);
            if (!this.isNewer(inputFile, outputFile)) {
                this.getLog().info((CharSequence)("Not compiling, target is up-to-date: " + outputFile));
                continue;
            }
            Commandline cl = cf.createCommandline(inputFile);
            this.getLog().debug((CharSequence)("Executing: " + cl.toString()));
            LoggerStreamConsumer out = new LoggerStreamConsumer(this.getLog(), 1);
            LoggerStreamConsumer err = new LoggerStreamConsumer(this.getLog(), 2);
            try {
                CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
                continue;
            }
            catch (CommandLineException e) {
                this.getLog().error((CharSequence)("Could not execute " + cl.getExecutable() + "."), (Throwable)e);
            }
        }
        String basepath = this.targetBundle.replace('.', File.separatorChar);
        this.getLog().info((CharSequence)"Creating resource bundle for source locale");
        this.touch(new File(this.outputDirectory, basepath + "_" + this.sourceLocale + ".properties"));
        this.getLog().info((CharSequence)"Creating default resource bundle");
        this.touch(new File(this.outputDirectory, basepath + ".properties"));
    }

    private boolean isNewer(File inputFile, File outputFile) {
        return inputFile.lastModified() > outputFile.lastModified();
    }

    private void touch(File file) {
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Could not touch file: " + file.getName()), (Throwable)e);
            }
        }
    }

    private class MsgCatCommandlineFactory
    implements CommandlineFactory {
        private MsgCatCommandlineFactory() {
        }

        public File getOutputFile(File input) {
            String basepath = DistMojo.this.targetBundle.replace('.', File.separatorChar);
            String locale = input.getName().substring(0, input.getName().lastIndexOf(46));
            locale = GettextUtils.getJavaLocale(locale);
            File target = new File(DistMojo.this.outputDirectory, basepath + "_" + locale + ".properties");
            return target;
        }

        public Commandline createCommandline(File file) {
            Commandline cl = new Commandline();
            File outputFile = this.getOutputFile(file);
            File parent = outputFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            cl.setExecutable(DistMojo.this.msgcatCmd);
            cl.createArgument().setValue("--no-location");
            cl.createArgument().setValue("-p");
            cl.createArgument().setFile(file);
            cl.createArgument().setValue("-o");
            cl.createArgument().setFile(outputFile);
            return cl;
        }
    }

    private class MsgFmtCommandlineFactory
    implements CommandlineFactory {
        private MsgFmtCommandlineFactory() {
        }

        public File getOutputFile(File input) {
            String locale = this.getLocale(input);
            return new File(DistMojo.this.outputDirectory, DistMojo.this.targetBundle.replace('.', File.separatorChar) + "_" + locale + ".class");
        }

        private String getLocale(File file) {
            String locale = file.getName().substring(0, file.getName().lastIndexOf(46));
            return GettextUtils.getJavaLocale(locale);
        }

        public Commandline createCommandline(File file) {
            Commandline cl = new Commandline();
            cl.setExecutable(DistMojo.this.msgfmtCmd);
            if ("2".equals(DistMojo.this.javaVersion)) {
                cl.createArgument().setValue("--java2");
            } else {
                cl.createArgument().setValue("--java");
            }
            cl.createArgument().setValue("-d");
            cl.createArgument().setFile(DistMojo.this.outputDirectory);
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(DistMojo.this.targetBundle);
            cl.createArgument().setValue("-l");
            cl.createArgument().setValue(this.getLocale(file));
            cl.createArgument().setFile(file);
            DistMojo.this.getLog().warn((CharSequence)cl.toString());
            return cl;
        }
    }

    private static interface CommandlineFactory {
        public Commandline createCommandline(File var1);

        public File getOutputFile(File var1);
    }
}

