/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.maven.gettext;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.xnap.commons.maven.gettext.AbstractGettextMojo;
import org.xnap.commons.maven.gettext.LoggerStreamConsumer;

public class MergeMojo
extends AbstractGettextMojo {
    protected String msgmergeCmd;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Invoking msgmerge for po files in '" + this.poDirectory.getAbsolutePath() + "'."));
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.poDirectory);
        ds.setIncludes(new String[]{"**/*.po"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            this.getLog().info((CharSequence)("Processing " + files[i]));
            Commandline cl = new Commandline();
            cl.setExecutable(this.msgmergeCmd);
            cl.createArgument().setValue("-q");
            cl.createArgument().setValue("--backup=numbered");
            cl.createArgument().setValue("-U");
            cl.createArgument().setFile(new File(this.poDirectory, files[i]));
            cl.createArgument().setValue(new File(this.poDirectory, this.keysFile).getAbsolutePath());
            this.getLog().debug((CharSequence)("Executing: " + cl.toString()));
            LoggerStreamConsumer out = new LoggerStreamConsumer(this.getLog(), 1);
            LoggerStreamConsumer err = new LoggerStreamConsumer(this.getLog(), 2);
            try {
                CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
                continue;
            }
            catch (CommandLineException e) {
                this.getLog().error((CharSequence)("Could not execute " + this.msgmergeCmd + "."), (Throwable)e);
            }
        }
    }
}

