/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.reader.gtfs.GraphHopperGtfs;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupHelper;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import io.dropwizard.lifecycle.Managed;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperManaged
implements Managed {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GraphHopper graphHopper;

    public GraphHopperManaged(GraphHopperConfig configuration, ObjectMapper objectMapper) {
        JsonFeatureCollection landmarkSplittingFeatureCollection;
        ObjectMapper localObjectMapper = objectMapper.copy();
        localObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String splitAreaLocation = configuration.get("prepare.lm.split_area_location", "");
        try (InputStreamReader reader = splitAreaLocation.isEmpty() ? new InputStreamReader(LandmarkStorage.class.getResource("map.geo.json").openStream(), Helper.UTF_CS) : new InputStreamReader((InputStream)new FileInputStream(splitAreaLocation), Helper.UTF_CS);){
            landmarkSplittingFeatureCollection = (JsonFeatureCollection)localObjectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
        }
        catch (IOException e1) {
            this.logger.error("Problem while reading border map GeoJSON. Skipping this.", (Throwable)e1);
            landmarkSplittingFeatureCollection = null;
        }
        this.graphHopper = configuration.has("gtfs.file") ? new GraphHopperGtfs(configuration) : new GraphHopperOSM(landmarkSplittingFeatureCollection).forServer();
        if (!configuration.get("spatial_rules.location", "").isEmpty()) {
            throw new RuntimeException("spatial_rules.location has been deprecated. Please use spatial_rules.borders_directory instead.");
        }
        String spatialRuleBordersDirLocation = configuration.get("spatial_rules.borders_directory", "");
        if (!spatialRuleBordersDirLocation.isEmpty()) {
            BBox maxBounds = BBox.parseBBoxString((String)configuration.get("spatial_rules.max_bbox", "-180, 180, -90, 90"));
            Path bordersDirectory = Paths.get(spatialRuleBordersDirLocation, new String[0]);
            ArrayList<JsonFeatureCollection> jsonFeatureCollections = new ArrayList<JsonFeatureCollection>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(bordersDirectory, "*.{geojson,json}");){
                for (Path borderFile : stream) {
                    BufferedReader reader = Files.newBufferedReader(borderFile, StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        JsonFeatureCollection jsonFeatureCollection = (JsonFeatureCollection)localObjectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
                        jsonFeatureCollections.add(jsonFeatureCollection);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SpatialRuleLookupHelper.buildAndInjectCountrySpatialRules((GraphHopper)this.graphHopper, (Envelope)new Envelope(maxBounds.minLon, maxBounds.maxLon, maxBounds.minLat, maxBounds.maxLat), jsonFeatureCollections);
        }
        this.graphHopper.init(configuration);
    }

    public void start() {
        this.graphHopper.importOrLoad();
        this.logger.info("loaded graph at:{}, data_reader_file:{}, encoded values:{}, {}", new Object[]{this.graphHopper.getGraphHopperLocation(), this.graphHopper.getDataReaderFile(), this.graphHopper.getEncodingManager().toEncodedValuesAsString(), this.graphHopper.getGraphHopperStorage().toDetailsString()});
    }

    public GraphHopper getGraphHopper() {
        return this.graphHopper;
    }

    public void stop() {
        this.graphHopper.close();
    }
}

