/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.ProfileConfig;
import com.graphhopper.http.WebHelper;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.Isochrone;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="isochrone")
public class IsochroneResource {
    private static final Logger logger = LoggerFactory.getLogger(IsochroneResource.class);
    private final GraphHopper graphHopper;
    private final EncodingManager encodingManager;
    private final GeometryFactory geometryFactory = new GeometryFactory();

    @Inject
    public IsochroneResource(GraphHopper graphHopper, EncodingManager encodingManager) {
        this.graphHopper = graphHopper;
        this.encodingManager = encodingManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context UriInfo uriInfo, @QueryParam(value="buckets") @DefaultValue(value="1") int nBuckets, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") GHPoint point, @QueryParam(value="time_limit") @DefaultValue(value="600") long timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") double distanceInMeter, @QueryParam(value="type") @DefaultValue(value="json") String respType) {
        if (nBuckets > 20 || nBuckets < 1) {
            throw new IllegalArgumentException("Number of buckets has to be in the range [1, 20]");
        }
        if (point == null) {
            throw new IllegalArgumentException("point parameter cannot be null");
        }
        StopWatch sw = new StopWatch().start();
        if (respType != null && !respType.equalsIgnoreCase("json") && !respType.equalsIgnoreCase("geojson")) {
            throw new IllegalArgumentException("Format not supported:" + respType);
        }
        HintsMap hintsMap = new HintsMap();
        RouteResource.initHints(hintsMap, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        hintsMap.putObject("ch.disable", (Object)true);
        hintsMap.putObject("lm.disable", (Object)true);
        ProfileConfig profile = this.graphHopper.resolveProfile(hintsMap);
        if (profile.isTurnCosts()) {
            throw new IllegalArgumentException("Isochrone calculation does not support turn costs yet");
        }
        FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
        DefaultEdgeFilter edgeFilter = DefaultEdgeFilter.allEdges((FlagEncoder)encoder);
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        QueryResult qr = locationIndex.findClosest(point.lat, point.lon, (EdgeFilter)edgeFilter);
        if (!qr.isValid()) {
            throw new IllegalArgumentException("Point not found:" + point);
        }
        GraphHopperStorage graph = this.graphHopper.getGraphHopperStorage();
        QueryGraph queryGraph = QueryGraph.lookup((Graph)graph, (QueryResult)qr);
        Weighting weighting = this.graphHopper.createWeighting(profile, (PMap)hintsMap);
        if (hintsMap.has("block_area")) {
            weighting = new BlockAreaWeighting(weighting, GraphEdgeIdFinder.createBlockArea((Graph)graph, (LocationIndex)locationIndex, Collections.singletonList(point), (HintsMap)hintsMap, (EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)encoder)));
        }
        Isochrone isochrone = new Isochrone((Graph)queryGraph, weighting, reverseFlow);
        if (distanceInMeter > 0.0) {
            isochrone.setDistanceLimit(distanceInMeter);
        } else {
            isochrone.setTimeLimit((double)timeLimitInSeconds);
        }
        List buckets = isochrone.searchGPS(qr.getClosestNode(), nBuckets);
        if (isochrone.getVisitedNodes() > this.graphHopper.getMaxVisitedNodes() / 5) {
            throw new IllegalArgumentException("Too many nodes would have to explored (" + isochrone.getVisitedNodes() + "). Let us know if you need this increased.");
        }
        ArrayList<JsonFeature> features = new ArrayList<JsonFeature>();
        ArrayList<ConstraintVertex> sites = new ArrayList<ConstraintVertex>();
        for (int i = 0; i < buckets.size(); ++i) {
            List level = (List)buckets.get(i);
            for (Object coord : level) {
                ConstraintVertex site = new ConstraintVertex((Coordinate)coord);
                site.setZ((double)i);
                sites.add(site);
            }
        }
        ConformingDelaunayTriangulator conformingDelaunayTriangulator = new ConformingDelaunayTriangulator(sites, 0.0);
        conformingDelaunayTriangulator.setConstraints(new ArrayList(), new ArrayList());
        conformingDelaunayTriangulator.formInitialDelaunay();
        conformingDelaunayTriangulator.enforceConstraints();
        Geometry convexHull = conformingDelaunayTriangulator.getConvexHull();
        if (!(convexHull instanceof Polygon)) {
            throw new IllegalArgumentException("Too few points found. Please try a different 'point' or a larger 'time_limit'.");
        }
        QuadEdgeSubdivision tin = conformingDelaunayTriangulator.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (!tin.isFrameVertex(vertex)) continue;
            vertex.setZ(Double.MAX_VALUE);
        }
        ArrayList<Coordinate[]> polygonShells = new ArrayList<Coordinate[]>();
        ContourBuilder contourBuilder = new ContourBuilder(tin);
        for (int i = 0; i < buckets.size() - 1; ++i) {
            MultiPolygon multiPolygon = contourBuilder.computeIsoline((double)i + 0.5);
            Polygon maxPolygon = this.heuristicallyFindMainConnectedComponent(multiPolygon, this.geometryFactory.createPoint(new Coordinate(point.lon, point.lat)));
            polygonShells.add(maxPolygon.getExteriorRing().getCoordinates());
        }
        for (Coordinate[] polygonShell : polygonShells) {
            JsonFeature feature = new JsonFeature();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("bucket", features.size());
            if (respType.equalsIgnoreCase("geojson")) {
                properties.put("copyrights", WebHelper.COPYRIGHTS);
            }
            feature.setProperties(properties);
            feature.setGeometry((Geometry)this.geometryFactory.createPolygon(polygonShell));
            features.add(feature);
        }
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        ObjectNode finalJson = null;
        if (respType.equalsIgnoreCase("geojson")) {
            json.put("type", "FeatureCollection");
            json.putPOJO("features", features);
            finalJson = json;
        } else {
            json.putPOJO("polygons", features);
            finalJson = WebHelper.jsonResponsePutInfo((ObjectNode)json, (float)sw.getSeconds());
        }
        sw.stop();
        logger.info("took: " + sw.getSeconds() + ", visited nodes:" + isochrone.getVisitedNodes() + ", " + uriInfo.getQueryParameters());
        return Response.ok((Object)finalJson).header("X-GH-Took", (Object)("" + sw.getSeconds() * 1000.0f)).build();
    }

    private Polygon heuristicallyFindMainConnectedComponent(MultiPolygon multiPolygon, Point point) {
        int maxPoints = 0;
        Polygon maxPolygon = null;
        for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
            if (polygon.contains((Geometry)point)) {
                return polygon;
            }
            if (polygon.getNumPoints() <= maxPoints) continue;
            maxPoints = polygon.getNumPoints();
            maxPolygon = polygon;
        }
        return maxPolygon;
    }
}

