/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.ProfileConfig;
import com.graphhopper.http.GHPointParam;
import com.graphhopper.http.WebHelper;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.ProfileResolver;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import io.dropwizard.jersey.params.IntParam;
import io.dropwizard.jersey.params.LongParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hibernate.validator.constraints.Range;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="isochrone")
public class IsochroneResource {
    private static final Logger logger = LoggerFactory.getLogger(IsochroneResource.class);
    private final GraphHopper graphHopper;
    private final ProfileResolver profileResolver;
    private final EncodingManager encodingManager;
    private final GeometryFactory geometryFactory = new GeometryFactory();

    @Inject
    public IsochroneResource(GraphHopper graphHopper, ProfileResolver profileResolver, EncodingManager encodingManager) {
        this.graphHopper = graphHopper;
        this.profileResolver = profileResolver;
        this.encodingManager = encodingManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context UriInfo uriInfo, @QueryParam(value="profile") String profileName, @QueryParam(value="buckets") @Range(min=1L, max=20L) @DefaultValue(value="1") @Range(min=1L, max=20L) IntParam nBuckets, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") @NotNull GHPointParam point, @QueryParam(value="time_limit") @DefaultValue(value="600") LongParam timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") LongParam distanceLimitInMeter, @QueryParam(value="weight_limit") @DefaultValue(value="-1") LongParam weightLimit, @QueryParam(value="type") @DefaultValue(value="json") ResponseType respType) {
        double limit;
        StopWatch sw = new StopWatch().start();
        PMap hintsMap = new PMap();
        RouteResource.initHints(hintsMap, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        hintsMap.putObject("ch.disable", (Object)true);
        hintsMap.putObject("lm.disable", (Object)true);
        if (Helper.isEmpty((String)profileName)) {
            profileName = this.profileResolver.resolveProfile(hintsMap).getName();
            RouteResource.removeLegacyParameters(hintsMap);
        }
        RouteResource.errorIfLegacyParameters(hintsMap);
        ProfileConfig profile = this.graphHopper.getProfile(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("The requested profile '" + profileName + "' does not exist");
        }
        FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
        DefaultEdgeFilter edgeFilter = DefaultEdgeFilter.allEdges((FlagEncoder)encoder);
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        QueryResult qr = locationIndex.findClosest(((GHPoint)point.get()).lat, ((GHPoint)point.get()).lon, (EdgeFilter)edgeFilter);
        if (!qr.isValid()) {
            throw new IllegalArgumentException("Point not found:" + (Object)((Object)point));
        }
        GraphHopperStorage graph = this.graphHopper.getGraphHopperStorage();
        QueryGraph queryGraph = QueryGraph.lookup((Graph)graph, (QueryResult)qr);
        Weighting weighting = this.graphHopper.createWeighting(profile, hintsMap);
        if (hintsMap.has("block_area")) {
            weighting = new BlockAreaWeighting(weighting, GraphEdgeIdFinder.createBlockArea((Graph)graph, (LocationIndex)locationIndex, Collections.singletonList(point.get()), (PMap)hintsMap, (EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)encoder)));
        }
        TraversalMode traversalMode = profile.isTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
        ShortestPathTree shortestPathTree = new ShortestPathTree((Graph)queryGraph, weighting, reverseFlow, traversalMode);
        if ((Long)weightLimit.get() > 0L) {
            limit = ((Long)weightLimit.get()).longValue();
            shortestPathTree.setWeightLimit(limit + Math.max(limit * 0.14, 2000.0));
        } else if ((Long)distanceLimitInMeter.get() > 0L) {
            limit = ((Long)distanceLimitInMeter.get()).longValue();
            shortestPathTree.setDistanceLimit(limit + Math.max(limit * 0.14, 2000.0));
        } else {
            limit = (Long)timeLimitInSeconds.get() * 1000L;
            shortestPathTree.setTimeLimit(limit + Math.max(limit * 0.14, 200000.0));
        }
        ArrayList<Double> zs = new ArrayList<Double>();
        for (int i = 0; i < (Integer)nBuckets.get(); ++i) {
            zs.add(limit / (double)((Integer)nBuckets.get() - i));
        }
        NodeAccess na = queryGraph.getNodeAccess();
        ArrayList sites = new ArrayList();
        shortestPathTree.search(qr.getClosestNode(), label -> {
            double exploreValue = (Long)weightLimit.get() > 0L ? label.weight : ((Long)distanceLimitInMeter.get() > 0L ? label.distance : (double)label.time);
            double lat = na.getLatitude(label.node);
            double lon = na.getLongitude(label.node);
            ConstraintVertex site = new ConstraintVertex(new Coordinate(lon, lat));
            site.setZ(exploreValue);
            sites.add(site);
            if (label.parent != null) {
                double lat2 = na.getLatitude(label.parent.node);
                double lon2 = na.getLongitude(label.parent.node);
                ConstraintVertex site2 = new ConstraintVertex(new Coordinate((lon + lon2) / 2.0, (lat + lat2) / 2.0));
                site2.setZ(exploreValue);
                sites.add(site2);
            }
        });
        int consumedNodes = sites.size();
        if (consumedNodes > this.graphHopper.getMaxVisitedNodes() / 3) {
            throw new IllegalArgumentException("Too many nodes would be included in post processing (" + consumedNodes + "). Let us know if you need this increased.");
        }
        ArrayList<JsonFeature> features = new ArrayList<JsonFeature>();
        ConformingDelaunayTriangulator conformingDelaunayTriangulator = new ConformingDelaunayTriangulator(sites, 0.0);
        conformingDelaunayTriangulator.setConstraints(new ArrayList(), new ArrayList());
        conformingDelaunayTriangulator.formInitialDelaunay();
        conformingDelaunayTriangulator.enforceConstraints();
        Geometry convexHull = conformingDelaunayTriangulator.getConvexHull();
        if (!(convexHull instanceof Polygon)) {
            throw new IllegalArgumentException("Too few points found. Please try a different 'point' or a larger 'time_limit'.");
        }
        QuadEdgeSubdivision tin = conformingDelaunayTriangulator.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (!tin.isFrameVertex(vertex)) continue;
            vertex.setZ(Double.MAX_VALUE);
        }
        ArrayList<Coordinate[]> polygonShells = new ArrayList<Coordinate[]>();
        ContourBuilder contourBuilder = new ContourBuilder(tin.getEdges());
        for (Double z : zs) {
            MultiPolygon multiPolygon = contourBuilder.computeIsoline(z.doubleValue());
            Polygon maxPolygon = this.heuristicallyFindMainConnectedComponent(multiPolygon, this.geometryFactory.createPoint(new Coordinate(((GHPoint)point.get()).lon, ((GHPoint)point.get()).lat)));
            polygonShells.add(maxPolygon.getExteriorRing().getCoordinates());
        }
        for (Coordinate[] polygonShell : polygonShells) {
            JsonFeature feature = new JsonFeature();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("bucket", features.size());
            if (respType == ResponseType.geojson) {
                properties.put("copyrights", WebHelper.COPYRIGHTS);
            }
            feature.setProperties(properties);
            feature.setGeometry((Geometry)this.geometryFactory.createPolygon(polygonShell));
            features.add(feature);
        }
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        ObjectNode finalJson = null;
        if (respType == ResponseType.geojson) {
            json.put("type", "FeatureCollection");
            json.putPOJO("features", features);
            finalJson = json;
        } else {
            json.putPOJO("polygons", features);
            finalJson = WebHelper.jsonResponsePutInfo((ObjectNode)json, (float)sw.getSeconds());
        }
        sw.stop();
        logger.info("took: " + sw.getSeconds() + ", visited nodes:" + shortestPathTree.getVisitedNodes() + ", consumed nodes:" + consumedNodes + ", " + uriInfo.getQueryParameters());
        return Response.ok((Object)finalJson).header("X-GH-Took", (Object)("" + sw.getSeconds() * 1000.0f)).build();
    }

    private Polygon heuristicallyFindMainConnectedComponent(MultiPolygon multiPolygon, Point point) {
        int maxPoints = 0;
        Polygon maxPolygon = null;
        for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
            if (polygon.contains((Geometry)point)) {
                return polygon;
            }
            if (polygon.getNumPoints() <= maxPoints) continue;
            maxPoints = polygon.getNumPoints();
            maxPolygon = polygon;
        }
        return maxPolygon;
    }

    static enum ResponseType {
        json,
        geojson;

    }
}

