/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeatureCollection;
import io.dropwizard.lifecycle.Managed;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperManaged
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger(GraphHopperManaged.class);
    private final GraphHopper graphHopper;

    public GraphHopperManaged(GraphHopperConfig configuration) {
        this.graphHopper = configuration.has("gtfs.file") ? new GraphHopperGtfs(configuration) : new GraphHopper();
        String customAreasDirectory = configuration.getString("custom_areas.directory", "");
        JsonFeatureCollection globalAreas = GraphHopperManaged.resolveCustomAreas(customAreasDirectory);
        String customModelFolder = configuration.getString("custom_models.directory", configuration.getString("custom_model_folder", ""));
        List<Profile> newProfiles = GraphHopperManaged.resolveCustomModelFiles(customModelFolder, configuration.getProfiles(), globalAreas);
        configuration.setProfiles(newProfiles);
        this.graphHopper.init(configuration);
    }

    public static JsonFeatureCollection resolveCustomAreas(String customAreasDirectory) {
        JsonFeatureCollection globalAreas = new JsonFeatureCollection();
        if (!customAreasDirectory.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JtsModule());
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(customAreasDirectory, new String[0]), "*.{geojson,json}");){
                for (Path customAreaFile : stream) {
                    BufferedReader reader = Files.newBufferedReader(customAreaFile, StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        globalAreas.getFeatures().addAll(((JsonFeatureCollection)mapper.readValue((Reader)reader, JsonFeatureCollection.class)).getFeatures());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                logger.info("Will make " + globalAreas.getFeatures().size() + " areas available to all custom profiles. Found in " + customAreasDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return globalAreas;
    }

    public static List<Profile> resolveCustomModelFiles(String customModelFolder, List<Profile> profiles, JsonFeatureCollection globalAreas) {
        ObjectMapper jsonOM = Jackson.newObjectMapper();
        ArrayList<Profile> newProfiles = new ArrayList<Profile>();
        for (Profile profile : profiles) {
            CustomModel customModel;
            if (!"custom".equals(profile.getWeighting())) {
                newProfiles.add(profile);
                continue;
            }
            Object cm = profile.getHints().getObject("custom_model", null);
            if (cm != null) {
                try {
                    customModel = (CustomModel)jsonOM.readValue(jsonOM.writeValueAsBytes(cm), CustomModel.class);
                    newProfiles.add((Profile)new CustomProfile(profile).setCustomModel(customModel));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot load custom_model from " + cm + " for profile " + profile.getName() + ". If you are trying to load from a file, use 'custom_model_file' instead.", ex);
                }
            }
            String customModelFileName = profile.getHints().getString("custom_model_file", "");
            if (customModelFileName.isEmpty()) {
                throw new IllegalArgumentException("Missing 'custom_model' or 'custom_model_file' field in profile '" + profile.getName() + "'. To use default specify custom_model_file: empty");
            }
            if ("empty".equals(customModelFileName)) {
                customModel = new CustomModel();
                newProfiles.add((Profile)new CustomProfile(profile).setCustomModel(customModel));
            } else {
                if (customModelFileName.contains(File.separator)) {
                    throw new IllegalArgumentException("Use custom_models.directory for the custom_model_file parent");
                }
                if (!customModelFileName.endsWith(".json")) {
                    throw new IllegalArgumentException("Yaml is no longer supported, see #2672. Use JSON with optional comments //");
                }
                try {
                    String string = Helper.readJSONFileWithoutComments((String)Paths.get(customModelFolder, new String[0]).resolve(customModelFileName).toFile().getAbsolutePath());
                    customModel = (CustomModel)jsonOM.readValue(string, CustomModel.class);
                    newProfiles.add((Profile)new CustomProfile(profile).setCustomModel(customModel));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot load custom_model from location " + customModelFileName + " for profile " + profile.getName(), ex);
                }
            }
            customModel.addAreas(globalAreas);
        }
        return newProfiles;
    }

    public void start() {
        this.graphHopper.importOrLoad();
        logger.info("loaded graph at:{}, data_reader_file:{}, encoded values:{}, {} ints for edge flags, {}", new Object[]{this.graphHopper.getGraphHopperLocation(), this.graphHopper.getOSMFile(), this.graphHopper.getEncodingManager().toEncodedValuesAsString(), this.graphHopper.getEncodingManager().getIntsForFlags(), this.graphHopper.getBaseGraph().toDetailsString()});
    }

    public GraphHopper getGraphHopper() {
        return this.graphHopper;
    }

    public void stop() {
        this.graphHopper.close();
    }
}

