/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.impl.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.beetl.core.Configuration;
import org.beetl.core.runtime.IBeetlCache;

public class CaffeineCache
implements IBeetlCache {
    Cache<Object, Object> cache;

    @Override
    public void init(Configuration configuration) {
        int size = configuration.getIntProperty("cache.size", 256);
        int duration = configuration.getIntProperty("cache.duration", 30);
        this.cache = Caffeine.newBuilder().expireAfterAccess((long)duration, TimeUnit.MINUTES).maximumSize((long)size).build();
    }

    @Override
    public Object get(Object key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public Object get(Object key, Function function) {
        return this.cache.get(key, function);
    }

    @Override
    public void remove(Object key) {
        this.cache.invalidate(key);
    }

    @Override
    public void set(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public void clearAll() {
        this.cache.invalidateAll();
    }

    @Override
    public long size() {
        this.cache.cleanUp();
        return this.cache.estimatedSize();
    }
}

