/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.GroupTemplate;
import org.beetl.core.config.BeetlConfig;
import org.beetl.core.misc.ByteClassLoader;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.om.ReflectBeanAA;
import org.beetl.core.om.asm.BeanEnhanceUtils;
import org.beetl.core.om.asm.EnhanceClassGenerator;
import org.beetl.core.util.Log;

public class AsmBeanFactory {
    private static final boolean DEBUG = BeetlConfig.DEBUG;
    private static final String TAG = "AsmBeanFactory";
    private final Map<Class<?>, AttributeAccess> beanMap = new ConcurrentHashMap();
    private final Map<ClassLoader, ByteClassLoader> classLoaders = new ConcurrentHashMap<ClassLoader, ByteClassLoader>();
    ClassLoader classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : GroupTemplate.class.getClassLoader();
    ByteClassLoader byteContextLoader = new ByteClassLoader(this.classLoader);
    boolean usePropertyDescriptor;

    public AsmBeanFactory() {
        this.usePropertyDescriptor = false;
    }

    public AsmBeanFactory(boolean usePropertyDescriptor) {
        this.usePropertyDescriptor = usePropertyDescriptor;
    }

    public Object value(Object bean, String attrName) {
        Class<?> beanClass = bean.getClass();
        AttributeAccess generatedBean = this.generateBean(beanClass);
        return generatedBean == null ? null : generatedBean.value(bean, attrName);
    }

    public boolean isUsePropertyDescriptor() {
        return this.usePropertyDescriptor;
    }

    public void setUsePropertyDescriptor(boolean usePropertyDescriptor) {
        this.usePropertyDescriptor = usePropertyDescriptor;
    }

    public synchronized AttributeAccess generateBean(Class<?> beanClass) {
        if (this.beanMap.containsKey(beanClass)) {
            return this.beanMap.get(beanClass);
        }
        try {
            Class<?> enhanceClass;
            ClassLoader beanClassLoader = beanClass.getClassLoader();
            if (beanClassLoader == null) {
                this.beanMap.put(beanClass, ReflectBeanAA.INSTANCE);
                return ReflectBeanAA.INSTANCE;
            }
            byte[] code = EnhanceClassGenerator.generate(beanClass, this.usePropertyDescriptor);
            String generatedBeanName = EnhanceClassGenerator.createGeneratedClassName(beanClass);
            ByteClassLoader byteLoader = this.classLoaders.get(beanClassLoader);
            if (byteLoader == null) {
                byteLoader = new ByteClassLoader(beanClassLoader);
                this.classLoaders.putIfAbsent(beanClassLoader, byteLoader);
            }
            if ((enhanceClass = byteLoader.findClassByName(generatedBeanName)) == null) {
                enhanceClass = byteLoader.defineClass(generatedBeanName, code);
            }
            Object obj = enhanceClass.newInstance();
            this.beanMap.put(beanClass, (AttributeAccess)obj);
            return this.beanMap.get(beanClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Object loadContextClassLoader(byte[] code, String className) {
        Object obj;
        try {
            Class<?> enhanceClass = this.byteContextLoader.findClassByName(className);
            if (enhanceClass == null) {
                enhanceClass = this.byteContextLoader.defineClass(className, code);
            }
            obj = enhanceClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
        return obj;
    }

    private static void writeClassToFile(byte[] code, Class<?> beanClass, String generatedBeanName) {
        try {
            String classPath = beanClass.getResource("").getPath();
            File file = new File(classPath, BeanEnhanceUtils.getSimpleClassName(generatedBeanName) + ".class");
            if (DEBUG) {
                Log.d(TAG, file.getAbsolutePath());
            }
            System.out.println(file.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(code);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

