/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.Scaler;

public final class HashConfigWrapper {
    private final HashConfig config;
    private final Scaler minLoadInverse;
    private final Scaler targetLoadInverse;
    private final Scaler maxLoad;
    private final Scaler maxLoadInverse;
    private final Scaler growthFactor;

    public HashConfigWrapper(HashConfig config) {
        this.config = config;
        this.minLoadInverse = Scaler.by(config.getMinLoad() > 0.0 ? 1.0 / config.getMinLoad() : Double.MAX_VALUE);
        this.targetLoadInverse = Scaler.by(1.0 / config.getTargetLoad());
        this.maxLoad = Scaler.by(config.getMaxLoad());
        this.maxLoadInverse = Scaler.by(1.0 / config.getMaxLoad());
        this.growthFactor = Scaler.by(config.getGrowthFactor());
    }

    public HashConfig config() {
        return this.config;
    }

    public int maxCapacity(int size) {
        return this.minLoadInverse.scaleUpper(size);
    }

    public long maxCapacity(long size) {
        return this.minLoadInverse.scaleUpper(size);
    }

    public int targetCapacity(int size) {
        return this.targetLoadInverse.scaleUpper(size);
    }

    public long targetCapacity(long size) {
        return this.targetLoadInverse.scaleUpper(size);
    }

    public int minCapacity(int size) {
        return this.maxLoadInverse.scaleUpper(size);
    }

    public long minCapacity(long size) {
        return this.maxLoadInverse.scaleUpper(size);
    }

    public int maxSize(int capacity) {
        return this.maxLoad.scaleLower(capacity);
    }

    public long maxSize(long capacity) {
        return this.maxLoad.scaleLower(capacity);
    }

    public int grow(int capacity) {
        return this.growthFactor.scaleLower(capacity);
    }

    public long grow(long capacity) {
        return this.growthFactor.scaleLower(capacity);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        assert (obj.getClass() != HashConfig.class);
        return obj instanceof HashConfigWrapper && this.config.equals(((HashConfigWrapper)obj).config());
    }

    public String toString() {
        return "HashConfigWrapper{config=" + this.config + "}";
    }
}

