/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.c2ws.servlet;

import com.legstar.proxy.invoke.ProxyConfigurationException;
import com.legstar.proxy.invoke.ProxyInvokerException;
import com.legstar.proxy.invoke.ServiceProxy;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C2wsProxy
extends HttpServlet {
    static final long serialVersionUID = 1L;
    private static final String BINARY_CONTENT_TYPE = "binary/octet-stream";
    private static final String APPLICATION_CONTENT_TYPE = "application/octet-stream";
    private static final String CORRELATION_ID_HDR = "Correlation-id";
    private static final int MAX_TRACES_BYTES = 500;
    private ServiceProxy _serviceProxy;
    private static final Log LOG = LogFactory.getLog(C2wsProxy.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initializing ");
        }
        HashMap<String, String> proxyConfig = new HashMap<String, String>();
        Enumeration en = this.getServletConfig().getInitParameterNames();
        while (en.hasMoreElements()) {
            this.setInitParameter(proxyConfig, (String)en.nextElement(), null);
        }
        try {
            this._serviceProxy = new ServiceProxy(proxyConfig);
        }
        catch (ProxyConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        long startTime = System.currentTimeMillis();
        String requestID = request.getHeader(CORRELATION_ID_HDR);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start proxy request " + requestID + " from client " + request.getRemoteHost()));
        }
        if (!this.isSupportedContentType(request)) {
            throw new ServletException("Content type " + request.getContentType() + " is not supported");
        }
        try {
            int n;
            int requestBytesLen = request.getContentLength();
            byte[] requestBytes = new byte[requestBytesLen];
            ServletInputStream in = request.getInputStream();
            int offset = 0;
            while ((n = in.read(requestBytes, offset, requestBytesLen - offset)) != -1) {
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Request data from host:");
                C2wsProxy.traceData(requestID, requestBytes, LOG);
            }
            byte[] replyBytes = this.getServiceProxy().invoke(requestID, requestBytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Reply data to host:");
                C2wsProxy.traceData(requestID, replyBytes, LOG);
            }
            response.setContentType(request.getContentType());
            response.getOutputStream().write(replyBytes);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ProxyInvokerException e) {
            throw new ServletException((Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End proxy request " + requestID + " from client " + request.getRemoteHost() + " serviced in " + (endTime - startTime) + " msecs"));
        }
    }

    private boolean isSupportedContentType(HttpServletRequest request) {
        return request.getContentType().trim().compareToIgnoreCase(BINARY_CONTENT_TYPE) == 0 || request.getContentType().trim().compareToIgnoreCase(APPLICATION_CONTENT_TYPE) == 0;
    }

    private void setInitParameter(Map<String, String> proxyConfig, String parameterName, String defaultValue) {
        String value = this.getServletConfig().getInitParameter(parameterName);
        if (value == null || value.length() == 0) {
            value = defaultValue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parameter " + parameterName + " not found." + " Using default value: " + value));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parameter " + parameterName + " found." + " Using value: " + value));
        }
        proxyConfig.put(parameterName.replace("c2ws.", ""), value);
    }

    public static void traceData(String requestID, byte[] data, Log log) {
        StringBuilder dumpLine = new StringBuilder();
        StringBuilder dumpString = new StringBuilder();
        for (int i = 0; i < data.length && i < 500; ++i) {
            String dumpChar = String.format("%02X ", data[i] & 0xFF);
            dumpLine.append(dumpChar);
            dumpChar = Character.isValidCodePoint(data[i]) ? String.format("%c", data[i]) : "?";
            if (dumpChar.length() > 0) {
                dumpString.append(dumpChar);
            } else {
                dumpString.append(" ");
            }
            if (i % 16 != 15 && i != data.length - 1) continue;
            while (i % 16 < 15) {
                dumpLine.append("   ");
                ++i;
            }
            dumpLine.append(" -- ");
            dumpLine.append((CharSequence)dumpString);
            log.debug((Object)dumpLine);
            dumpString = new StringBuilder();
            dumpLine = new StringBuilder();
        }
        if (data.length > 500) {
            dumpLine.append(String.format("...data was truncated at %d bytes", 500));
            log.debug((Object)dumpLine);
        }
    }

    public ServiceProxy getServiceProxy() {
        return this._serviceProxy;
    }
}

