/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.proxy.invoke;

import com.legstar.coxb.host.HostContext;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.IHostTransformers;
import com.legstar.proxy.invoke.IOperationProxy;
import com.legstar.proxy.invoke.IProxyInvoker;
import com.legstar.proxy.invoke.ProxyConfigurationException;
import com.legstar.proxy.invoke.ProxyInvokerException;
import com.legstar.proxy.invoke.ProxyInvokerFactory;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperationProxy
implements IOperationProxy {
    private static final long serialVersionUID = 1L;
    private IProxyInvoker mProxyInvoker;
    private IHostTransformers mRequestTransformers;
    private IHostTransformers mResponseTransformers;
    private Map<String, String> mConfig;

    public AbstractOperationProxy(Map<String, String> config) throws ProxyConfigurationException {
        this.mConfig = config;
        try {
            this.mProxyInvoker = ProxyInvokerFactory.createProxyInvoker(config);
        }
        catch (ProxyInvokerException e) {
            throw new ProxyConfigurationException(e);
        }
    }

    @Override
    public byte[] invoke(String requestID, byte[] requestBytes) throws ProxyInvokerException {
        return this.invoke(this.getConfig(), requestID, requestBytes);
    }

    @Override
    public byte[] invoke(Map<String, String> config, String requestID, byte[] requestBytes) throws ProxyInvokerException {
        try {
            IProxyInvoker proxyInvoker = this.getProxyInvoker(config);
            String hostCharset = this.getHostCharset(config);
            Object requestObject = this.getRequestTransformers().toJava(requestBytes, hostCharset);
            Object replyObject = proxyInvoker.invoke(requestID, requestObject);
            return this.getResponseTransformers().toHost(replyObject, hostCharset);
        }
        catch (HostTransformException e) {
            throw new ProxyInvokerException((Exception)((Object)e));
        }
    }

    @Override
    public IProxyInvoker getProxyInvoker(Map<String, String> config) throws ProxyInvokerException {
        if (config != null && !this.mProxyInvoker.isSameConfig(config)) {
            return ProxyInvokerFactory.createProxyInvoker(config);
        }
        return this.mProxyInvoker;
    }

    @Override
    public String getHostCharset(Map<String, String> config) {
        String hostCharset = config.get("hostCharset");
        if (hostCharset == null || hostCharset.length() == 0) {
            hostCharset = HostContext.getDefaultHostCharsetName();
        }
        return hostCharset;
    }

    @Override
    public IProxyInvoker getProxyInvoker() {
        return this.mProxyInvoker;
    }

    @Override
    public void setProxyInvoker(IProxyInvoker proxyInvoker) {
        this.mProxyInvoker = proxyInvoker;
    }

    @Override
    public IHostTransformers getRequestTransformers() {
        return this.mRequestTransformers;
    }

    @Override
    public void setRequestTransformers(IHostTransformers requestTransformers) {
        this.mRequestTransformers = requestTransformers;
    }

    @Override
    public IHostTransformers getResponseTransformers() {
        return this.mResponseTransformers;
    }

    @Override
    public void setResponseTransformers(IHostTransformers responseTransformers) {
        this.mResponseTransformers = responseTransformers;
    }

    @Override
    public Map<String, String> getConfig() {
        return this.mConfig;
    }

    @Override
    public void setConfig(Map<String, String> config) {
        this.mConfig = config;
    }

    public String getConfigParm(String parmName) throws ProxyConfigurationException {
        String value = this.getConfig().get(parmName);
        if (value == null || value.length() == 0) {
            throw new ProxyConfigurationException("Missing configuration parameter " + parmName);
        }
        return value;
    }
}

