/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.proxy.invoke;

import com.legstar.coxb.util.ClassUtil;
import com.legstar.proxy.invoke.IProxyInvoker;
import com.legstar.proxy.invoke.ProxyInvokerException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyInvokerFactory {
    public static final String DEFAULT_PROXY_INVOKER_CLASS_NAME = "com.legstar.proxy.invoke.jaxws.WebServiceInvoker";

    private ProxyInvokerFactory() {
    }

    public static IProxyInvoker createProxyInvoker(Map<String, String> config) throws ProxyInvokerException {
        String className = config.get("proxyInvokerClassName");
        if (className == null || className.length() == 0) {
            className = DEFAULT_PROXY_INVOKER_CLASS_NAME;
        }
        try {
            Class proxyInvokerClass = ClassUtil.loadClass((String)className);
            Constructor constructor = proxyInvokerClass.getConstructor(Map.class);
            return (IProxyInvoker)constructor.newInstance(config);
        }
        catch (ClassNotFoundException e) {
            throw new ProxyInvokerException(e);
        }
        catch (SecurityException e) {
            throw new ProxyInvokerException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ProxyInvokerException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ProxyInvokerException(e);
        }
        catch (InstantiationException e) {
            throw new ProxyInvokerException(e);
        }
        catch (IllegalAccessException e) {
            throw new ProxyInvokerException(e);
        }
        catch (InvocationTargetException e) {
            throw new ProxyInvokerException(e.getTargetException());
        }
    }
}

