/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.proxy.invoke;

import com.legstar.coxb.util.ClassUtil;
import com.legstar.messaging.HostMessageFormatException;
import com.legstar.messaging.LegStarMessage;
import com.legstar.proxy.invoke.IOperationProxy;
import com.legstar.proxy.invoke.ProxyConfigurationException;
import com.legstar.proxy.invoke.ProxyInvokerException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProxy
implements Serializable {
    private static final long serialVersionUID = 9222944155913546563L;
    public static final String OPERATION_PROXY_CLASS_NAME_PROPERTY = "operationProxyClassName";
    public static final String DEFAULT_OPERATION_PROXY_CLASS_NAME = "com.legstar.proxy.invoke.ReflectOperationProxy";
    private static final Log LOG = LogFactory.getLog(ServiceProxy.class);
    private Map<String, String> mConfig;
    private IOperationProxy mOperationProxy;

    public ServiceProxy(Map<String, String> config) throws ProxyConfigurationException {
        this.mConfig = config == null ? new HashMap<String, String>() : config;
        this.mOperationProxy = this.getOperationProxy(this.mConfig);
    }

    private IOperationProxy getOperationProxy(Map<String, String> config) throws ProxyConfigurationException {
        try {
            String operationProxyClassName = config.get(OPERATION_PROXY_CLASS_NAME_PROPERTY);
            if (operationProxyClassName == null || operationProxyClassName.length() == 0) {
                operationProxyClassName = DEFAULT_OPERATION_PROXY_CLASS_NAME;
            }
            Class clazz = ClassUtil.loadClass((String)operationProxyClassName);
            Constructor constructor = clazz.getConstructor(Map.class);
            return (IOperationProxy)constructor.newInstance(config);
        }
        catch (SecurityException e) {
            throw new ProxyConfigurationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ProxyConfigurationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ProxyConfigurationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ProxyConfigurationException(e);
        }
        catch (InstantiationException e) {
            throw new ProxyConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ProxyConfigurationException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ProxyConfigurationException) {
                throw (ProxyConfigurationException)e.getTargetException();
            }
            throw new ProxyConfigurationException(e);
        }
    }

    public byte[] invoke(Map<String, String> config, String requestID, byte[] requestBytes) throws ProxyInvokerException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Servicing proxy request " + requestID));
            }
            boolean legstarMessaging = false;
            byte[] payload = requestBytes;
            if (LegStarMessage.isLegStarMessage((byte[])requestBytes)) {
                legstarMessaging = true;
                payload = LegStarMessage.getContentFromHostBytes((byte[])requestBytes);
            }
            byte[] replyBytes = this.getOperationProxy().invoke(config, requestID, payload);
            if (legstarMessaging) {
                return LegStarMessage.getHostBytesFromContent((byte[])replyBytes);
            }
            return replyBytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new ProxyInvokerException(e);
        }
        catch (HostMessageFormatException e) {
            throw new ProxyInvokerException((Exception)((Object)e));
        }
    }

    public byte[] invoke(String requestID, byte[] requestBytes) throws ProxyInvokerException {
        return this.invoke(this.getConfig(), requestID, requestBytes);
    }

    public Map<String, String> getConfig() {
        return this.mConfig;
    }

    public IOperationProxy getOperationProxy() {
        return this.mOperationProxy;
    }

    public void setCultureinfoProxyInvoker(IOperationProxy operationProxy) {
        this.mOperationProxy = operationProxy;
    }
}

