/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.proxy.invoke.jaxws;

import com.legstar.coxb.util.JAXBAnnotationException;
import com.legstar.coxb.util.JAXBElementDescriptor;
import com.legstar.coxb.util.NameUtil;
import com.legstar.proxy.invoke.AbstractProxyInvoker;
import com.legstar.proxy.invoke.ProxyInvokerException;
import com.legstar.proxy.invoke.jaxws.WebServiceInvokerException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceInvoker
extends AbstractProxyInvoker {
    public static final String WSDL_URL_PROPERTY = "wsdlUrl";
    public static final String WSDL_TARGET_NAMESPACE_PROPERTY = "wsdlTargetNamespace";
    public static final String WSDL_SERVICE_NAME_PROPERTY = "wsdlServiceName";
    public static final String WSDL_PORT_NAME_PROPERTY = "wsdlPortName";
    public static final String REQUEST_JAXB_TYPE_PROPERTY = "requestJaxbType";
    public static final String REQUEST_JAXB_PACKAGE_NAME_PROPERTY = "requestJaxbPackageName";
    public static final String RESPONSE_JAXB_TYPE_PROPERTY = "responseJaxbType";
    public static final String RESPONSE_JAXB_PACKAGE_NAME_PROPERTY = "responseJaxbPackageName";
    private String mWsdlUrl;
    private String mWsdlTargetNamespace;
    private String mWsdlServiceName;
    private String mWsdlPortName;
    private JAXBElementDescriptor mRequestElementDescriptor;
    private JAXBElementDescriptor mResponseElementDescriptor;
    private final Dispatch<Object> _dispatcher;
    private final Log _log = LogFactory.getLog(this.getClass());

    public WebServiceInvoker(Map<String, String> config) throws WebServiceInvokerException {
        super(config);
        this.mWsdlUrl = config.get(WSDL_URL_PROPERTY);
        if (this.mWsdlUrl == null || this.mWsdlUrl.length() == 0) {
            throw new WebServiceInvokerException("You must specify a wsdl URL using the wsdlUrl attribute");
        }
        this.mWsdlTargetNamespace = config.get(WSDL_TARGET_NAMESPACE_PROPERTY);
        if (this.mWsdlTargetNamespace == null || this.mWsdlTargetNamespace.length() == 0) {
            throw new WebServiceInvokerException("You must specify a wsdl target namespace using the wsdlTargetNamespace attribute");
        }
        this.mWsdlServiceName = config.get(WSDL_SERVICE_NAME_PROPERTY);
        if (this.mWsdlServiceName == null || this.mWsdlServiceName.length() == 0) {
            throw new WebServiceInvokerException("You must specify a service name using the wsdlServiceName attribute");
        }
        this.mWsdlPortName = config.get(WSDL_PORT_NAME_PROPERTY);
        if (this.mWsdlPortName == null || this.mWsdlPortName.length() == 0) {
            throw new WebServiceInvokerException("You must specify a port name using the wsdlPortName attribute");
        }
        String requestJaxbType = config.get(REQUEST_JAXB_TYPE_PROPERTY);
        if (requestJaxbType == null || requestJaxbType.length() == 0) {
            throw new WebServiceInvokerException("You must specify a jaxb request type using the requestJaxbType attribute");
        }
        String requestJaxbPackageName = config.get(REQUEST_JAXB_PACKAGE_NAME_PROPERTY);
        if (requestJaxbPackageName == null || requestJaxbPackageName.length() == 0) {
            throw new WebServiceInvokerException("You must specify a jaxb request package name using the requestJaxbPackageName attribute");
        }
        String responseJaxbType = config.get(RESPONSE_JAXB_TYPE_PROPERTY);
        if (responseJaxbType == null || responseJaxbType.length() == 0) {
            throw new WebServiceInvokerException("You must specify a jaxb response type using the responseJaxbType attribute");
        }
        String responseJaxbPackageName = config.get(RESPONSE_JAXB_PACKAGE_NAME_PROPERTY);
        if (responseJaxbPackageName == null || responseJaxbPackageName.length() == 0) {
            throw new WebServiceInvokerException("You must specify a jaxb response package name using the responseJaxbPackageName attribute");
        }
        try {
            this.mRequestElementDescriptor = new JAXBElementDescriptor(requestJaxbPackageName, requestJaxbType);
            this.mResponseElementDescriptor = new JAXBElementDescriptor(responseJaxbPackageName, responseJaxbType);
            this._dispatcher = this.createDispatcher();
        }
        catch (JAXBAnnotationException e) {
            throw new WebServiceInvokerException((Exception)((Object)e));
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"WebServiceInvoker setup configuration:");
            this._log.debug((Object)("Wsdl Url=" + this.getWsdlUrl()));
            this._log.debug((Object)("Wsdl service name=" + this.getWsdlServiceName()));
            this._log.debug((Object)("Wsdl target namespace=" + this.getWsdlTargetNamespace()));
            this._log.debug((Object)("Wsdl port=" + this.getWsdlPortName()));
            this._log.debug((Object)("Request element=[" + this.getRequestElementDescriptor().toString() + "]"));
            this._log.debug((Object)("Response element=[" + this.getResponseElementDescriptor().toString() + "]"));
            this._log.debug((Object)("Dispatcher=[" + this._dispatcher + "]"));
        }
    }

    @Override
    public synchronized <T> T invoke(String requestID, Object oRequest) throws ProxyInvokerException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("About to call invokeDispatch for service=" + this.getWsdlServiceName() + " request ID=" + requestID));
        }
        Object replyObject = this.invokeDispatch(oRequest);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Returned from invokeDispatch for service=" + this.getWsdlServiceName() + " request ID=" + requestID));
        }
        return (T)replyObject;
    }

    private JAXBContext createJAXBContext() throws WebServiceInvokerException {
        try {
            if (this.getResponseElementDescriptor().getJaxbPackageName().compareTo(this.getRequestElementDescriptor().getJaxbPackageName()) == 0) {
                return JAXBContext.newInstance((Class[])new Class[]{this.getRequestElementDescriptor().getObjectFactory().getClass()});
            }
            return JAXBContext.newInstance((Class[])new Class[]{this.getRequestElementDescriptor().getObjectFactory().getClass(), this.getResponseElementDescriptor().getObjectFactory().getClass()});
        }
        catch (JAXBException e) {
            throw new WebServiceInvokerException((Exception)((Object)e));
        }
    }

    private Object invokeDispatch(Object oRequest) throws WebServiceInvokerException {
        try {
            Object oResponse;
            if (this.getRequestElementDescriptor().isXmlRootElement()) {
                oResponse = this._dispatcher.invoke(oRequest);
            } else {
                JAXBElement<?> jeRequest = this.getJAXBElement(this.getRequestElementDescriptor().getObjectFactory(), this.getRequestElementDescriptor().getElementName(), oRequest);
                oResponse = this._dispatcher.invoke(jeRequest);
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("invokeDispatch returned " + oResponse));
            }
            if (this.getResponseElementDescriptor().isXmlRootElement()) {
                return oResponse;
            }
            return ((JAXBElement)oResponse).getValue();
        }
        catch (SOAPFaultException e) {
            throw new WebServiceInvokerException(this.getFaultReasonText(e), e);
        }
    }

    public String getFaultReasonText(SOAPFaultException e) {
        SOAPFault fault;
        if (this._log.isDebugEnabled()) {
            fault = e.getFault();
            if (fault != null) {
                Detail detail;
                QName code = fault.getFaultCodeAsQName();
                String string = fault.getFaultString();
                String actor = fault.getFaultActor();
                this._log.debug((Object)"SOAP fault contains: ");
                this._log.debug((Object)("  Fault code = " + code.toString()));
                this._log.debug((Object)("  Local name = " + code.getLocalPart()));
                this._log.debug((Object)("  Namespace prefix = " + code.getPrefix() + ", bound to " + code.getNamespaceURI()));
                this._log.debug((Object)("  Fault string = " + string));
                if (actor != null) {
                    this._log.debug((Object)("  Fault actor = " + actor));
                }
                if ((detail = fault.getDetail()) != null) {
                    Iterator entries = detail.getDetailEntries();
                    while (entries.hasNext()) {
                        DetailEntry newEntry = (DetailEntry)entries.next();
                        String value = newEntry.getValue();
                        this._log.debug((Object)("  Detail entry = " + value));
                    }
                }
            } else {
                this._log.debug((Object)e);
            }
        }
        if ((fault = e.getFault()) != null) {
            StringBuffer faultMessage = new StringBuffer(e.getFault().getFaultString());
            Detail detail = fault.getDetail();
            if (detail != null) {
                Iterator entries = detail.getDetailEntries();
                while (entries.hasNext()) {
                    DetailEntry newEntry = (DetailEntry)entries.next();
                    faultMessage.append(" [" + newEntry.getValue() + "]");
                }
            }
            return faultMessage.toString();
        }
        return e.getMessage();
    }

    public Dispatch<Object> createDispatcher() throws WebServiceInvokerException {
        QName serviceQname = new QName(this.getWsdlTargetNamespace(), this.getWsdlServiceName());
        QName portQname = new QName(this.getWsdlTargetNamespace(), this.getWsdlPortName());
        Service service = Service.create((QName)serviceQname);
        service.addPort(portQname, "http://schemas.xmlsoap.org/wsdl/soap/http", this.getWsdlUrl());
        Dispatch dispatcher = service.createDispatch(portQname, this.createJAXBContext(), Service.Mode.PAYLOAD);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("New javax.xml.ws.Dispatch created for " + this.getWsdlServiceName()));
        }
        return dispatcher;
    }

    private JAXBElement<?> getJAXBElement(Object objectFactory, String elementName, Object type) throws WebServiceInvokerException {
        try {
            String createName = "create" + NameUtil.toClassName((String)elementName);
            Method creator = objectFactory.getClass().getMethod(createName, type.getClass());
            return (JAXBElement)creator.invoke(objectFactory, type);
        }
        catch (IllegalAccessException e) {
            throw new WebServiceInvokerException(e);
        }
        catch (SecurityException e) {
            throw new WebServiceInvokerException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WebServiceInvokerException(e);
        }
        catch (IllegalArgumentException e) {
            throw new WebServiceInvokerException(e);
        }
        catch (InvocationTargetException e) {
            throw new WebServiceInvokerException(e);
        }
    }

    public JAXBElementDescriptor getRequestElementDescriptor() {
        return this.mRequestElementDescriptor;
    }

    public JAXBElementDescriptor getResponseElementDescriptor() {
        return this.mResponseElementDescriptor;
    }

    public String getWsdlServiceName() {
        return this.mWsdlServiceName;
    }

    public String getWsdlPortName() {
        return this.mWsdlPortName;
    }

    public String getWsdlTargetNamespace() {
        return this.mWsdlTargetNamespace;
    }

    public String getWsdlUrl() {
        return this.mWsdlUrl;
    }
}

