/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.proxy.invoke.pojo;

import com.legstar.coxb.util.ClassUtil;
import com.legstar.proxy.invoke.AbstractProxyInvoker;
import com.legstar.proxy.invoke.ProxyInvokerException;
import com.legstar.proxy.invoke.pojo.PojoInvokerException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoInvoker
extends AbstractProxyInvoker {
    public static final String POJO_CLASS_NAME_PROPERTY = "pojoClassName";
    public static final String POJO_METHOD_NAME_PROPERTY = "pojoMethodName";
    private String mPojoClassName;
    private String mPojoMethodName;
    private Class<?> mPojoClass;
    private Method mPojoMethod;
    private final Log _log = LogFactory.getLog(PojoInvoker.class);

    public PojoInvoker(Map<String, String> config) throws PojoInvokerException {
        super(config);
        this.mPojoClassName = config.get(POJO_CLASS_NAME_PROPERTY);
        if (this.mPojoClassName == null || this.mPojoClassName.length() == 0) {
            throw new PojoInvokerException("You must specify a POJO class name using the pojoClassName attribute");
        }
        this.mPojoMethodName = config.get(POJO_METHOD_NAME_PROPERTY);
        if (this.mPojoMethodName == null || this.mPojoMethodName.length() == 0) {
            throw new PojoInvokerException("You must specify a POJO method name using the pojoMethodName attribute");
        }
        try {
            this.mPojoClass = ClassUtil.loadClass((String)this.mPojoClassName);
            boolean methodFound = false;
            for (Method method : this.mPojoClass.getMethods()) {
                if (!method.getName().equals(this.mPojoMethodName)) continue;
                this.mPojoMethod = method;
                methodFound = true;
                break;
            }
            if (!methodFound) {
                throw new PojoInvokerException("Class " + this.mPojoClassName + " does not implement method " + this.mPojoMethodName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new PojoInvokerException(e);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"PojoInvoker setup configuration:");
            this._log.debug((Object)("POJO class name=" + this.getPojoClassName()));
            this._log.debug((Object)("POJO method name=" + this.getPojoMethodName()));
        }
    }

    @Override
    public <T> T invoke(String requestID, Object oRequest) throws ProxyInvokerException {
        Object replyObject;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("About to call method " + this.getPojoMethodName() + " for POJO=" + this.getPojoClassName() + " request ID=" + requestID));
        }
        try {
            Object processor = this.getPojoClass().newInstance();
            replyObject = this.getPojoMethod().invoke(processor, oRequest);
        }
        catch (IllegalArgumentException e) {
            throw new ProxyInvokerException(e);
        }
        catch (InstantiationException e) {
            throw new ProxyInvokerException(e);
        }
        catch (IllegalAccessException e) {
            throw new ProxyInvokerException(e);
        }
        catch (InvocationTargetException e) {
            throw new ProxyInvokerException(e);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Returned from method " + this.getPojoMethodName() + " for POJO=" + this.getPojoClassName() + " request ID=" + requestID));
        }
        return (T)replyObject;
    }

    public String getPojoClassName() {
        return this.mPojoClassName;
    }

    public String getPojoMethodName() {
        return this.mPojoMethodName;
    }

    public Class<?> getPojoClass() {
        return this.mPojoClass;
    }

    public Method getPojoMethod() {
        return this.mPojoMethod;
    }
}

