/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.codegen;

import com.legstar.codegen.CodeGenMakeException;
import com.legstar.codegen.CodeGenUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenMake
extends Task {
    private String mGeneratorName;
    private String mCodeGenMakeFileName;
    private String mModelName;
    private Object mModel;
    public static final String CODEGEN_TARGET_XML_E = "target";
    public static final String CODEGEN_TARGET_NAME_XML_A = "name";
    public static final String CODEGEN_TARGET_DIR_XML_A = "dir";
    public static final String CODEGEN_STEP_XML_E = "step";
    public static final String CODEGEN_TEMPLATE_NAME_XML_A = "templateName";
    public static final String CODEGEN_TEMPLATE_TARGET_FILE_XML_A = "targetFile";
    public static final String CODEGEN_TEMPLATE_TARGET_CHARSETNAME_XML_A = "targetCharsetName";
    private final Log _log = LogFactory.getLog(CodeGenMake.class);

    public void init() {
        try {
            this._log.info((Object)"Initializing Code generation make processor");
            CodeGenUtil.initVelocity();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    public void execute() {
        long start = System.currentTimeMillis();
        try {
            this._log.debug((Object)"Start make processor");
            Document doc = this.getInput();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Make file name   = " + this.mCodeGenMakeFileName));
                this._log.debug((Object)("Model name       = " + this.mModelName));
            }
            this.processTargets(doc);
        }
        catch (CodeGenMakeException e) {
            this._log.error((Object)"Make processor failure", (Throwable)e);
            throw new BuildException(e.getMessage());
        }
        long end = System.currentTimeMillis();
        this._log.info((Object)("Make processing success for " + this.mCodeGenMakeFileName));
        this._log.info((Object)("Duration = " + (end - start) + " ms"));
    }

    private Document getInput() throws CodeGenMakeException {
        if (this.mCodeGenMakeFileName == null || this.mCodeGenMakeFileName.length() == 0) {
            throw new CodeGenMakeException("Missing make file parameter");
        }
        if (this.mModelName == null || this.mModelName.length() == 0) {
            throw new CodeGenMakeException("Missing model name parameter");
        }
        if (this.mModel == null) {
            throw new CodeGenMakeException("Missing model parameter");
        }
        File makeFile = new File(this.mCodeGenMakeFileName);
        if (!makeFile.exists()) {
            throw new CodeGenMakeException("Code generation make file " + makeFile + " does not exist");
        }
        return this.load(makeFile);
    }

    private void processTargets(Document doc) throws CodeGenMakeException {
        NodeList listOfElements = doc.getElementsByTagName(CODEGEN_TARGET_XML_E);
        if (listOfElements == null || listOfElements.getLength() == 0) {
            throw new CodeGenMakeException("Empty or invalid code generation make file");
        }
        Element targetElement = (Element)listOfElements.item(0);
        String targetName = targetElement.getAttribute(CODEGEN_TARGET_NAME_XML_A);
        if (targetName == null || targetName.length() == 0) {
            throw new CodeGenMakeException("Missing name attribute for target element");
        }
        String targetDir = targetElement.getAttribute(CODEGEN_TARGET_DIR_XML_A);
        if (targetDir != null && targetDir.length() > 0) {
            try {
                CodeGenUtil.checkDirectory(targetDir, true);
            }
            catch (IllegalArgumentException e) {
                throw new CodeGenMakeException(e);
            }
        }
        listOfElements = targetElement.getElementsByTagName(CODEGEN_STEP_XML_E);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Processing target");
            this._log.debug((Object)("Target name      = " + targetName));
            this._log.debug((Object)("Target directory = " + targetDir));
        }
        for (int i = 0; i < listOfElements.getLength(); ++i) {
            Element templateEl = (Element)listOfElements.item(i);
            String templateName = templateEl.getAttribute(CODEGEN_TEMPLATE_NAME_XML_A);
            if (templateName == null || templateName.length() == 0) {
                throw new CodeGenMakeException("Missing template name attribute for step element");
            }
            String templateTargetFileName = templateEl.getAttribute(CODEGEN_TEMPLATE_TARGET_FILE_XML_A);
            if (templateTargetFileName == null || templateTargetFileName.length() == 0) {
                throw new CodeGenMakeException("Missing template target file name attribute for step element");
            }
            String templateTargetCharsetName = templateEl.getAttribute(CODEGEN_TEMPLATE_TARGET_CHARSETNAME_XML_A);
            if (templateTargetCharsetName.length() == 0) {
                templateTargetCharsetName = null;
            }
            CodeGenUtil.processTemplate(this.mGeneratorName, templateName, this.mModelName, this.mModel, this.getParameters(templateEl), CodeGenUtil.getFile(targetDir, templateTargetFileName), templateTargetCharsetName);
        }
    }

    private Map<String, Object> getParameters(Element templateEl) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        NodeList childs = templateEl.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Element parmEl;
            String value;
            if (!(childs.item(i) instanceof Element) || (value = (parmEl = (Element)childs.item(i)).getAttribute("value")) == null) continue;
            parameters.put(parmEl.getNodeName(), value);
        }
        return parameters;
    }

    public Document load(File makeFile) throws CodeGenMakeException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setNamespaceAware(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(makeFile);
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new CodeGenMakeException(e);
        }
        catch (SAXException e) {
            throw new CodeGenMakeException(e);
        }
        catch (IOException e) {
            throw new CodeGenMakeException(e);
        }
    }

    public String getCodeGenMakeFileName() {
        return this.mCodeGenMakeFileName;
    }

    public void setCodeGenMakeFileName(String codeGenMakeFileName) {
        this.mCodeGenMakeFileName = codeGenMakeFileName;
    }

    public String getModelName() {
        return this.mModelName;
    }

    public void setModelName(String modelName) {
        this.mModelName = modelName;
    }

    public Object getModel() {
        return this.mModel;
    }

    public void setModel(Object model) {
        this.mModel = model;
    }

    public String getGeneratorName() {
        return this.mGeneratorName;
    }

    public void setGeneratorName(String generatorName) {
        this.mGeneratorName = generatorName;
    }
}

