/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.codegen.tasks;

import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;

public class CommonsLoggingListener
implements BuildListener,
BuildLogger {
    private Log _log;

    public CommonsLoggingListener(Log log) {
        this._log = log;
    }

    public void buildStarted(BuildEvent event) {
        this._log.info((Object)"Build started.");
    }

    public void buildFinished(BuildEvent event) {
        if (event.getException() == null) {
            this._log.info((Object)"Build finished.");
        } else {
            this._log.error((Object)"Build finished with error.", event.getException());
        }
    }

    public void targetStarted(BuildEvent event) {
        this._log.debug((Object)("Start: " + event.getTarget().getName()));
    }

    public void targetFinished(BuildEvent event) {
        String targetName = event.getTarget().getName();
        if (event.getException() == null) {
            this._log.debug((Object)("Target end: " + targetName));
        } else {
            this._log.error((Object)("Target \"" + targetName + "\" finished with error."), event.getException());
        }
    }

    public void taskStarted(BuildEvent event) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Task \"" + event.getTask().getTaskName() + "\" started."));
        }
    }

    public void taskFinished(BuildEvent event) {
        if (event.getException() == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Task \"" + event.getTask().getTaskName() + "\" finished."));
            }
        } else {
            this._log.error((Object)("Target \"" + event.getTask().getTaskName() + "\" finished with error."), event.getException());
        }
    }

    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        String message = event.getMessage();
        switch (priority) {
            case 2: {
                this._log.info((Object)message);
                break;
            }
            case 1: {
                this._log.warn((Object)message);
                break;
            }
            case 0: {
                this._log.error((Object)message);
                break;
            }
            case 4: {
                this._log.debug((Object)message);
                break;
            }
            case 3: {
                this._log.debug((Object)message);
            }
        }
    }

    public void setMessageOutputLevel(int level) {
    }

    public void setOutputPrintStream(PrintStream output) {
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
    }
}

