/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.cob2avro;

import com.legstar.avro.cob2avro.DecimalUtils;
import com.legstar.base.context.CobolContext;
import com.legstar.base.type.CobolType;
import com.legstar.base.type.composite.CobolArrayType;
import com.legstar.base.type.composite.CobolChoiceType;
import com.legstar.base.type.composite.CobolComplexType;
import com.legstar.base.type.primitive.CobolPrimitiveType;
import com.legstar.base.visitor.FromCobolChoiceStrategy;
import com.legstar.base.visitor.FromCobolVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public class Cob2AvroVisitor
extends FromCobolVisitor {
    private Schema currentSchema;
    private Object resultObject;
    private final AvroPrimitiveTypeHandler primitiveTypeHandler;
    private final AvroChoiceTypeAlternativeHandler choiceTypeHandler;

    public Cob2AvroVisitor(CobolContext cobolContext, byte[] hostData, Schema schema) {
        this(cobolContext, hostData, 0, hostData.length, null, schema);
    }

    public Cob2AvroVisitor(CobolContext cobolContext, byte[] hostData, int start, int length, Schema schema) {
        this(cobolContext, hostData, start, length, null, schema);
    }

    public Cob2AvroVisitor(CobolContext cobolContext, byte[] hostData, int start, int length, FromCobolChoiceStrategy customChoiceStrategy, Schema schema) {
        this(cobolContext, hostData, start, length, customChoiceStrategy, null, schema);
    }

    public Cob2AvroVisitor(CobolContext cobolContext, byte[] hostData, int start, int length, FromCobolChoiceStrategy customChoiceStrategy, Set<String> customVariables, Schema schema) {
        super(cobolContext, hostData, start, length, customChoiceStrategy, customVariables);
        this.currentSchema = schema;
        this.primitiveTypeHandler = new AvroPrimitiveTypeHandler();
        this.choiceTypeHandler = new AvroChoiceTypeAlternativeHandler();
    }

    public void visit(CobolComplexType type) {
        GenericData.Record record = new GenericData.Record(this.currentSchema);
        super.visitComplexType(type, (FromCobolVisitor.ComplexTypeChildHandler)new AvroComplexTypeChildHandler((GenericRecord)record));
        this.resultObject = record;
    }

    public void visit(CobolArrayType type) {
        ArrayList<Object> list = new ArrayList<Object>();
        super.visitCobolArrayType(type, (FromCobolVisitor.ArrayTypeItemHandler)new AvroArrayTypeItemHandler(list));
        this.resultObject = list;
    }

    public void visit(CobolChoiceType type) {
        super.visitCobolChoiceType(type, (FromCobolVisitor.ChoiceTypeAlternativeHandler)this.choiceTypeHandler);
    }

    public void visit(CobolPrimitiveType<?> type) {
        super.visitCobolPrimitiveType(type, (FromCobolVisitor.PrimitiveTypeHandler)this.primitiveTypeHandler);
    }

    public Object getResultObject() {
        return this.resultObject;
    }

    private class AvroPrimitiveTypeHandler
    implements FromCobolVisitor.PrimitiveTypeHandler {
        private AvroPrimitiveTypeHandler() {
        }

        public void preVisit(CobolPrimitiveType<?> type) {
        }

        public void postVisit(CobolPrimitiveType<?> type, Object value) {
            if (value instanceof BigDecimal) {
                Cob2AvroVisitor.this.resultObject = DecimalUtils.toByteBuffer((BigDecimal)value);
            } else if (value instanceof BigInteger) {
                Cob2AvroVisitor.this.resultObject = ((BigInteger)value).longValue();
            } else if (value instanceof Short) {
                Cob2AvroVisitor.this.resultObject = ((Short)value).intValue();
            } else {
                Cob2AvroVisitor.this.resultObject = value;
            }
        }
    }

    private class AvroChoiceTypeAlternativeHandler
    implements FromCobolVisitor.ChoiceTypeAlternativeHandler {
        private Schema previousSchema;

        private AvroChoiceTypeAlternativeHandler() {
        }

        public void preVisit(String alternativeName, int alternativeIndex, CobolType alternative) {
            this.previousSchema = Cob2AvroVisitor.this.currentSchema;
            Cob2AvroVisitor.this.currentSchema = (Schema)Cob2AvroVisitor.this.currentSchema.getTypes().get(alternativeIndex);
        }

        public void postVisit(String alternativeName, int alternativeIndex, CobolType alternative) {
            Cob2AvroVisitor.this.currentSchema = this.previousSchema;
        }
    }

    private class AvroArrayTypeItemHandler
    implements FromCobolVisitor.ArrayTypeItemHandler {
        private final List<Object> list;

        public AvroArrayTypeItemHandler(List<Object> list) {
            this.list = list;
        }

        public boolean preVisit(int itemIndex, CobolType item) {
            return true;
        }

        public boolean postVisit(int itemIndex, CobolType item) {
            this.list.add(Cob2AvroVisitor.this.resultObject);
            return true;
        }
    }

    private class AvroComplexTypeChildHandler
    implements FromCobolVisitor.ComplexTypeChildHandler {
        private final GenericRecord record;
        private Schema previousSchema;

        public AvroComplexTypeChildHandler(GenericRecord record) {
            this.record = record;
        }

        public boolean preVisit(String fieldName, int fieldIndex, CobolType child) {
            this.previousSchema = Cob2AvroVisitor.this.currentSchema;
            if (child instanceof CobolComplexType) {
                Schema childSchema = this.record.getSchema().getField(fieldName).schema();
                if (childSchema.getType().equals((Object)Schema.Type.UNION)) {
                    Cob2AvroVisitor.this.currentSchema = (Schema)childSchema.getTypes().get(0);
                } else {
                    Cob2AvroVisitor.this.currentSchema = this.record.getSchema().getField(fieldName).schema();
                }
            } else if (child instanceof CobolArrayType) {
                Cob2AvroVisitor.this.currentSchema = this.record.getSchema().getField(fieldName).schema().getElementType();
            } else if (child instanceof CobolChoiceType) {
                Cob2AvroVisitor.this.currentSchema = this.record.getSchema().getField(fieldName).schema();
            }
            return true;
        }

        public boolean postVisit(String fieldName, int fieldIndex, CobolType child) {
            this.record.put(fieldName, Cob2AvroVisitor.this.resultObject);
            Cob2AvroVisitor.this.currentSchema = this.previousSchema;
            return true;
        }
    }
}

