/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.cob2avro.io;

import com.legstar.avro.cob2avro.io.AbstractZosDatumReader;
import com.legstar.base.context.CobolContext;
import com.legstar.base.context.EbcdicCobolContext;
import com.legstar.base.type.composite.CobolComplexType;
import com.legstar.base.visitor.FromCobolChoiceStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;

public class ZosVarRdwDatumReader<D>
extends AbstractZosDatumReader<D> {
    public static final int RDW_LEN = 4;

    public ZosVarRdwDatumReader(InputStream inStream, long length, CobolComplexType cobolType, Schema schema) throws IOException {
        this(inStream, length, (CobolContext)new EbcdicCobolContext(), cobolType, null, schema);
    }

    public ZosVarRdwDatumReader(InputStream inStream, long length, CobolContext cobolContext, CobolComplexType cobolType, Schema schema) throws IOException {
        this(inStream, length, cobolContext, cobolType, null, schema);
    }

    public ZosVarRdwDatumReader(InputStream inStream, long length, CobolContext cobolContext, CobolComplexType cobolType, FromCobolChoiceStrategy customChoiceStrategy, Schema schema) throws IOException {
        super(inStream, length, cobolContext, cobolType, customChoiceStrategy, schema);
    }

    @Override
    public AbstractZosDatumReader.ReadRecordStatus readRecord(byte[] hostBytes, int processed) throws IOException {
        int bytesRead = 0;
        if (this.getBytesPrefetched() == 0) {
            bytesRead = this.readFully(hostBytes, 0, 4);
            if (bytesRead < 4) {
                throw new IOException("Not enough bytes left for a record descriptor word");
            }
            this.setBytesPrefetched(4);
        }
        int recordLen = ZosVarRdwDatumReader.getRecordLen(hostBytes);
        this.setBytesPrefetched(0);
        return new AbstractZosDatumReader.ReadRecordStatus(recordLen, bytesRead += this.readFully(hostBytes, this.getBytesPrefetched(), recordLen - this.getBytesPrefetched() + 4));
    }

    private static int getRecordLen(byte[] hostData) {
        return ZosVarRdwDatumReader.getRecordLen(hostData, 0, hostData.length);
    }

    private static int getRecordLen(byte[] hostData, int start, int length) {
        int len = ZosVarRdwDatumReader.getRawRdw(hostData, start, length);
        if (len < 4 || len > hostData.length) {
            throw new IllegalArgumentException("Record does not start with a Record Descriptor Word");
        }
        return len - 4;
    }

    public static int getRawRdw(byte[] hostData, int start, int length) {
        if (length - start < 4) {
            throw new IllegalArgumentException("Not enough bytes for an RDW");
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.put(0, (byte)0);
        buf.put(1, (byte)0);
        buf.put(2, hostData[start + 0]);
        buf.put(3, hostData[start + 1]);
        return buf.getInt();
    }

    @Override
    public int hostBytesPrefixLen() {
        return 4;
    }
}

