/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractLiferayMojo;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.tools.WebXMLBuilder;
import com.liferay.portal.tools.deploy.HookDeployer;
import com.liferay.portal.tools.deploy.LayoutTemplateDeployer;
import com.liferay.portal.tools.deploy.PortletDeployer;
import com.liferay.portal.tools.deploy.ThemeDeployer;
import com.liferay.portal.tools.deploy.WebDeployer;
import com.liferay.util.ant.CopyTask;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;

public class PluginDirectDeployerMojo
extends AbstractLiferayMojo {
    private File appServerDeployDir;
    private String appServerType;
    private String baseDir;
    private boolean customPortletXml;
    private boolean dependencyAddClassifier;
    private boolean dependencyAddVersion;
    private boolean dependencyAddVersionAndClassifier;
    private boolean dependencyCopyTransitive;
    private File deployDir;
    private String jbossPrefix;
    private String pluginName;
    private boolean unpackWar;
    private String warFileName;

    protected void deployExt() throws Exception {
        File sourceFile;
        String artifactId = this.project.getArtifactId();
        Build build = this.project.getBuild();
        if (artifactId.endsWith("ext-service")) {
            sourceFile = new File(build.getDirectory(), build.getFinalName() + "." + this.project.getPackaging());
            CopyTask.copyFile((File)sourceFile, (File)this.appServerLibGlobalDir, (String)("ext-" + this.pluginName + "-service.jar"), null, (boolean)true, (boolean)true);
            this.copyLibraryDependencies(this.appServerLibGlobalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-impl")) {
            sourceFile = new File(build.getDirectory(), build.getFinalName() + "." + this.project.getPackaging());
            CopyTask.copyFile((File)sourceFile, (File)this.appServerLibPortalDir, (String)("ext-" + this.pluginName + "-impl.jar"), null, (boolean)true, (boolean)true);
            File sourceDir = new File(build.getOutputDirectory());
            CopyTask.copyDirectory((File)sourceDir, (File)this.appServerClassesPortalDir, (String)"portal-*.properties,system-*.properties", null);
            this.copyLibraryDependencies(this.appServerLibPortalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-util-bridges") || artifactId.endsWith("ext-util-java") || artifactId.endsWith("ext-util-taglib")) {
            sourceFile = new File(build.getDirectory(), build.getFinalName() + "." + this.project.getPackaging());
            String fileName = "ext-" + this.pluginName;
            fileName = fileName + artifactId.substring(artifactId.lastIndexOf(45));
            fileName = fileName + ".jar";
            CopyTask.copyFile((File)sourceFile, (File)this.appServerLibPortalDir, (String)fileName, null, (boolean)true, (boolean)true);
            this.copyLibraryDependencies(this.appServerLibPortalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
        }
        if (artifactId.endsWith("ext-web")) {
            File sourceDir = new File(build.getDirectory(), build.getFinalName());
            CopyTask.copyDirectory((File)sourceDir, (File)this.appServerDeployDir, null, (String)"WEB-INF/web.xml", (boolean)true, (boolean)true);
            this.copyLibraryDependencies(this.appServerLibPortalDir, this.project.getArtifact(), this.dependencyAddVersion, this.dependencyAddClassifier, this.dependencyCopyTransitive);
            File originalWebXml = new File(this.appServerPortalDir, "WEB-INF/web.xml");
            File mergedWebXml = new File(this.appServerPortalDir, "WEB-INF/web.xml.merged");
            new WebXMLBuilder(originalWebXml.getAbsolutePath(), sourceDir + "/WEB-INF/web.xml", mergedWebXml.getAbsolutePath());
            FileUtil.move((File)mergedWebXml, (File)originalWebXml);
        }
        String packaging = this.project.getPackaging();
        if (artifactId.endsWith("-ext") && packaging.equals("war")) {
            File buildDir = new File(build.getDirectory(), build.getFinalName());
            File sourceFile2 = new File(buildDir, "WEB-INF/ext-" + this.pluginName + ".xml");
            CopyTask.copyFile((File)sourceFile2, (File)this.appServerPortalDir, (boolean)true, (boolean)true);
        }
    }

    protected void deployHook() throws Exception {
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        jars.add(this.appServerLibPortalDir.getAbsolutePath() + "/util-java.jar");
        new HookDeployer(wars, jars);
    }

    protected void deployLayoutTemplate() throws Exception {
        ArrayList wars = new ArrayList();
        ArrayList jars = new ArrayList();
        new LayoutTemplateDeployer(wars, jars);
    }

    protected void deployPortlet() throws Exception {
        String tldPath = this.appServerTldPortalDir.getAbsolutePath();
        System.setProperty("deployer.aui.taglib.dtd", tldPath + "/aui.tld");
        System.setProperty("deployer.custom.portlet.xml", String.valueOf(this.customPortletXml));
        System.setProperty("deployer.portlet.taglib.dtd", tldPath + "/liferay-portlet.tld");
        System.setProperty("deployer.portlet-ext.taglib.dtd", tldPath + "/liferay-portlet-ext.tld");
        System.setProperty("deployer.security.taglib.dtd", tldPath + "/liferay-security.tld");
        System.setProperty("deployer.theme.taglib.dtd", tldPath + "/liferay-theme.tld");
        System.setProperty("deployer.ui.taglib.dtd", tldPath + "/liferay-ui.tld");
        System.setProperty("deployer.util.taglib.dtd", tldPath + "/liferay-util.tld");
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.appServerLibPortalDir.getAbsolutePath();
        jars.add(libPath + "/util-bridges.jar");
        jars.add(libPath + "/util-java.jar");
        jars.add(libPath + "/util-taglib.jar");
        new PortletDeployer(wars, jars);
    }

    protected void deployTheme() throws Exception {
        String tldPath = this.appServerTldPortalDir.getAbsolutePath();
        System.setProperty("deployer.theme.taglib.dtd", tldPath + "/liferay-theme.tld");
        System.setProperty("deployer.util.taglib.dtd", tldPath + "/liferay-util.tld");
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.appServerLibPortalDir.getAbsolutePath();
        jars.add(libPath + "/util-java.jar");
        jars.add(libPath + "/util-taglib.jar");
        new ThemeDeployer(wars, jars);
    }

    protected void deployWeb() throws Exception {
        ArrayList wars = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        String libPath = this.appServerLibPortalDir.getAbsolutePath();
        jars.add(libPath + "/util-java.jar");
        new WebDeployer(wars, jars);
    }

    protected void doExecute() throws Exception {
        if (this.appServerLibGlobalDir == null) {
            throw new MojoExecutionException("The parameter appServerLibGlobalDir is required");
        }
        if (this.appServerLibPortalDir == null) {
            throw new MojoExecutionException("The parameter appServerLibPortalDir is required");
        }
        this.getLog().info((CharSequence)("Directly deploying " + this.project.getArtifactId()));
        this.getLog().debug((CharSequence)("appServerType: " + this.appServerType));
        this.getLog().debug((CharSequence)("baseDir: " + this.baseDir));
        this.getLog().debug((CharSequence)("deployDir: " + this.appServerDeployDir.getAbsolutePath()));
        this.getLog().debug((CharSequence)("jbossPrefix: " + this.jbossPrefix));
        this.getLog().debug((CharSequence)("pluginType: " + this.pluginType));
        this.getLog().debug((CharSequence)("unpackWar: " + this.unpackWar));
        System.setProperty("deployer.app.server.type", this.appServerType);
        System.setProperty("deployer.base.dir", this.baseDir);
        System.setProperty("deployer.dest.dir", this.appServerDeployDir.getAbsolutePath());
        System.setProperty("deployer.file.pattern", this.warFileName);
        System.setProperty("deployer.unpack.war", String.valueOf(this.unpackWar));
        if (this.dependencyAddVersionAndClassifier) {
            this.dependencyAddVersion = true;
            this.dependencyAddClassifier = true;
        }
        if (this.pluginType.equals("ext")) {
            this.deployExt();
        } else if (this.pluginType.equals("hook")) {
            this.deployHook();
        } else if (this.pluginType.equals("layouttpl")) {
            this.deployLayoutTemplate();
        } else if (this.pluginType.equals("portlet")) {
            this.deployPortlet();
        } else if (this.pluginType.equals("theme")) {
            this.deployTheme();
        } else if (this.pluginType.equals("web")) {
            this.deployWeb();
        }
    }
}

