/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractLiferayMojo;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class ThemeMergeMojo
extends AbstractLiferayMojo {
    private String parentTheme;
    private String themeType;
    private File webappDir;

    protected void doExecute() throws Exception {
        if (!this.workDir.exists()) {
            this.workDir.mkdirs();
        }
        String parentThemeGroupId = "com.liferay.portal";
        String parentThemeArtifactId = "portal-web";
        String parentThemeVersion = this.liferayVersion;
        String[] excludes = new String[]{"html/themes/classic/_diffs/**", "html/themes/control_panel/_diffs/**"};
        String[] includes = new String[]{"html/themes/_unstyled/**", "html/themes/_styled/**", "html/themes/classic/**", "html/themes/control_panel/**"};
        if (!(this.parentTheme.equals("_styled") || this.parentTheme.equals("_unstyled") || this.parentTheme.equals("classic") || this.parentTheme.equals("control_panel"))) {
            String[] parentThemeArray = this.parentTheme.split(":");
            parentThemeGroupId = parentThemeArray[0];
            parentThemeArtifactId = parentThemeArray[1];
            parentThemeVersion = parentThemeArray[2];
            excludes = new String[]{"WEB-INF/**"};
            includes = null;
        }
        Dependency dependency = this.createDependency(parentThemeGroupId, parentThemeArtifactId, parentThemeVersion, "", "war");
        Artifact artifact = this.resolveArtifact(dependency);
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact.getFile());
        unArchiver.setDestDirectory(this.workDir);
        unArchiver.setSourceFile(artifact.getFile());
        IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
        includeExcludeFileSelector.setExcludes(excludes);
        includeExcludeFileSelector.setIncludes(includes);
        unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
        unArchiver.extract();
        this.webappDir.mkdirs();
        if (parentThemeArtifactId.equals("portal-web")) {
            FileUtils.copyDirectory((File)new File(this.workDir, "html/themes/_unstyled"), (File)this.webappDir);
            this.getLog().info((CharSequence)("Copying html/themes/_unstyled to " + this.webappDir));
            if (!"_unstyled".equals(this.parentTheme)) {
                FileUtils.copyDirectory((File)new File(this.workDir, "html/themes/_styled"), (File)this.webappDir);
                this.getLog().info((CharSequence)("Copying html/themes/_styled to " + this.webappDir));
            }
            if (!"_unstyled".equals(this.parentTheme) && !"_styled".equals(this.parentTheme)) {
                FileUtils.copyDirectory((File)new File(this.workDir, "html/themes/" + this.parentTheme), (File)this.webappDir);
                this.getLog().info((CharSequence)("Copying html/themes/" + this.parentTheme + " to " + this.webappDir));
            }
        } else {
            FileUtils.copyDirectory((File)this.workDir, (File)this.webappDir);
        }
        File initFile = new File(this.webappDir, "templates/init." + this.themeType);
        FileUtils.deleteQuietly((File)initFile);
        File templatesDirectory = new File(this.webappDir, "templates/");
        String[] extensions = null;
        extensions = this.themeType.equals("ftl") ? new String[]{"vm"} : new String[]{"ftl"};
        Iterator itr = FileUtils.iterateFiles((File)templatesDirectory, (String[])extensions, (boolean)false);
        while (itr.hasNext()) {
            File file = (File)itr.next();
            FileUtils.deleteQuietly((File)file);
        }
    }
}

