/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.plugins;

import com.liferay.maven.plugins.AbstractLiferayMojo;
import com.liferay.maven.plugins.theme.Theme;
import com.liferay.maven.plugins.util.ContextReplace;
import com.liferay.maven.plugins.util.GetterUtil;
import com.liferay.maven.plugins.util.PortalUtil;
import com.liferay.maven.plugins.util.SAXReaderUtil;
import com.liferay.maven.plugins.util.StringUtil;
import com.liferay.maven.plugins.util.Validator;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.dom4j.Document;
import org.dom4j.Element;

public class ThemeMergeMojo
extends AbstractLiferayMojo {
    private String parentTheme;
    private String parentThemeArtifactGroupId;
    private String parentThemeArtifactId;
    private String parentThemeArtifactVersion;
    private String parentThemeId;
    private String themeId;
    private String themeType;
    private File webappDir;
    private File webappSourceDir;

    protected void cleanUpTemplates(File templatesDir) {
        File initFile = new File(templatesDir, "init." + this.themeType);
        FileUtils.deleteQuietly((File)initFile);
        String[] extensions = null;
        extensions = this.themeType.equals("ftl") ? new String[]{"vm", "jsp"} : (this.themeType.equals("jsp") ? new String[]{"vm", "ftl"} : new String[]{"ftl", "jsp"});
        Iterator iterator = FileUtils.iterateFiles((File)templatesDir, (String[])extensions, (boolean)false);
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            FileUtils.deleteQuietly((File)file);
        }
    }

    protected void doExecute() throws Exception {
        File liferayLookAndFeelXml;
        this.workDir = new File(this.workDir, "liferay-theme");
        if (!this.workDir.exists()) {
            this.workDir.mkdirs();
        }
        if (Validator.isNotNull(this.parentTheme)) {
            if (this.parentTheme.indexOf(":") > 0) {
                String[] parentThemeArray = this.parentTheme.split(":");
                this.parentThemeArtifactGroupId = parentThemeArray[0];
                this.parentThemeArtifactId = parentThemeArray[1];
                this.parentThemeArtifactVersion = parentThemeArray[2];
                this.parentThemeId = null;
            } else {
                this.parentThemeId = this.parentTheme;
            }
        }
        this.getLog().info((CharSequence)("Parent theme group ID " + this.parentThemeArtifactGroupId));
        this.getLog().info((CharSequence)("Parent theme artifact ID " + this.parentThemeArtifactId));
        this.getLog().info((CharSequence)("Parent theme version " + this.parentThemeArtifactVersion));
        this.getLog().info((CharSequence)("Parent theme ID " + this.parentThemeId));
        String[] excludes = null;
        String[] includes = null;
        boolean portalTheme = false;
        if (this.parentThemeArtifactGroupId.equals("com.liferay.portal") && this.parentThemeArtifactId.equals("portal-web")) {
            portalTheme = true;
        }
        if (!portalTheme) {
            Dependency dependency = this.createDependency(this.parentThemeArtifactGroupId, this.parentThemeArtifactId, this.parentThemeArtifactVersion, "", "war");
            Artifact artifact = this.resolveArtifact(dependency);
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(artifact.getFile());
            unArchiver.setDestDirectory(this.workDir);
            unArchiver.setSourceFile(artifact.getFile());
            IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
            includeExcludeFileSelector.setExcludes(excludes);
            includeExcludeFileSelector.setIncludes(includes);
            unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
            unArchiver.extract();
        }
        if ((liferayLookAndFeelXml = new File(this.webappSourceDir, "WEB-INF/liferay-look-and-feel.xml")).exists()) {
            Document document = SAXReaderUtil.read(liferayLookAndFeelXml, false);
            Element rootElement = document.getRootElement();
            List themeElements = rootElement.elements("theme");
            for (Element themeElement : themeElements) {
                String id = themeElement.attributeValue("id");
                if (Validator.isNotNull(this.themeId) && !this.themeId.equals(id)) continue;
                Theme targetTheme = this.readTheme(themeElement);
                if (portalTheme) {
                    this.mergePortalTheme(targetTheme);
                    continue;
                }
                File sourceLiferayLookAndFeelXml = new File(this.workDir, "WEB-INF/liferay-look-and-feel.xml");
                Theme sourceTheme = this.readTheme(this.parentThemeId, sourceLiferayLookAndFeelXml);
                this.mergeTheme(sourceTheme, targetTheme);
            }
        } else {
            String id = PortalUtil.getJsSafePortletId(this.project.getArtifactId());
            Theme targetTheme = this.readTheme(id, null);
            if (portalTheme) {
                this.mergePortalTheme(targetTheme);
            } else {
                File sourceLiferayLookAndFeelXml = new File(this.workDir, "WEB-INF/liferay-look-and-feel.xml");
                Theme sourceTheme = this.readTheme(this.parentThemeId, sourceLiferayLookAndFeelXml);
                this.mergeTheme(sourceTheme, targetTheme);
            }
        }
    }

    protected void mergePortalTheme(Theme targetTheme) throws Exception {
        File templatesDir = new File(this.webappDir, targetTheme.getTemplatesPath());
        templatesDir.mkdirs();
        FileUtils.copyDirectory((File)new File(this.appServerPortalDir, "html/themes/_unstyled/templates"), (File)templatesDir);
        this.getLog().info((CharSequence)("Copying html/themes/_unstyled/templates to " + templatesDir));
        File cssDir = new File(this.webappDir, targetTheme.getCssPath());
        cssDir.mkdirs();
        FileUtils.copyDirectory((File)new File(this.appServerPortalDir, "html/themes/_unstyled/css"), (File)cssDir);
        this.getLog().info((CharSequence)("Copying html/themes/_unstyled/css to " + cssDir));
        File imagesDir = new File(this.webappDir, targetTheme.getImagesPath());
        imagesDir.mkdirs();
        FileUtils.copyDirectory((File)new File(this.appServerPortalDir, "html/themes/_unstyled/images"), (File)imagesDir);
        this.getLog().info((CharSequence)("Copying html/themes/_unstyled/images to " + imagesDir));
        File javaScriptDir = new File(this.webappDir, targetTheme.getJavaScriptPath());
        javaScriptDir.mkdirs();
        FileUtils.copyDirectory((File)new File(this.appServerPortalDir, "html/themes/_unstyled/js"), (File)javaScriptDir);
        this.getLog().info((CharSequence)("Copying html/themes/_unstyled/js to " + javaScriptDir));
        if (this.parentThemeId.equals("_unstyled")) {
            this.mergeTheme(this.webappSourceDir, targetTheme, targetTheme);
            return;
        }
        FileUtils.copyDirectory((File)new File(this.appServerPortalDir, "html/themes/_styled/css"), (File)cssDir);
        this.getLog().info((CharSequence)("Copying html/themes/_styled/css to " + cssDir));
        FileUtils.copyDirectory((File)new File(this.appServerPortalDir, "html/themes/_styled/images"), (File)imagesDir);
        this.getLog().info((CharSequence)("Copying html/themes/_styled/images to " + imagesDir));
        if (this.parentThemeId.equals("_styled")) {
            this.mergeTheme(this.webappSourceDir, targetTheme, targetTheme);
            return;
        }
        File liferayLookAndFeelXml = new File(this.appServerPortalDir, "WEB-INF/liferay-look-and-feel.xml");
        Theme sourceTheme = this.readTheme(this.parentThemeId, liferayLookAndFeelXml);
        this.mergeTheme(this.appServerPortalDir, sourceTheme, targetTheme);
        this.mergeTheme(this.webappSourceDir, targetTheme, targetTheme);
    }

    protected void mergeTheme(File sourceDir, Theme sourceTheme, Theme targetTheme) throws Exception {
        File sourceTemplatesDir;
        File sourceJavaScriptDir;
        File sourceImagesDir;
        File sourceCssDir = new File(sourceDir, sourceTheme.getCssPath());
        if (sourceCssDir.exists()) {
            File targetCssDir = new File(this.webappDir, targetTheme.getCssPath());
            targetCssDir.mkdirs();
            FileUtils.copyDirectory((File)sourceCssDir, (File)targetCssDir);
            this.getLog().info((CharSequence)("Copying " + sourceCssDir + " to " + targetCssDir));
        }
        if ((sourceImagesDir = new File(sourceDir, sourceTheme.getImagesPath())).exists()) {
            File targetImagesDir = new File(this.webappDir, targetTheme.getImagesPath());
            targetImagesDir.mkdirs();
            FileUtils.copyDirectory((File)sourceImagesDir, (File)targetImagesDir);
            this.getLog().info((CharSequence)("Copying " + sourceImagesDir + " to " + targetImagesDir));
        }
        if ((sourceJavaScriptDir = new File(sourceDir, sourceTheme.getJavaScriptPath())).exists()) {
            File targetJavaScriptDir = new File(this.webappDir, targetTheme.getJavaScriptPath());
            targetJavaScriptDir.mkdirs();
            FileUtils.copyDirectory((File)sourceJavaScriptDir, (File)targetJavaScriptDir);
            this.getLog().info((CharSequence)("Copying " + sourceJavaScriptDir + " to " + targetJavaScriptDir));
        }
        if ((sourceTemplatesDir = new File(sourceDir, sourceTheme.getTemplatesPath())).exists()) {
            File targetTemplatesDir = new File(this.webappDir, targetTheme.getTemplatesPath());
            targetTemplatesDir.mkdirs();
            FileUtils.copyDirectory((File)sourceTemplatesDir, (File)targetTemplatesDir);
            this.getLog().info((CharSequence)("Copying " + sourceTemplatesDir + " to " + targetTemplatesDir));
            this.cleanUpTemplates(targetTemplatesDir);
        }
    }

    protected void mergeTheme(Theme sourceTheme, Theme targetTheme) throws Exception {
        this.mergeTheme(this.workDir, sourceTheme, targetTheme);
        this.mergeTheme(this.webappSourceDir, targetTheme, targetTheme);
    }

    protected Theme readTheme(Element themeElement) {
        String id = themeElement.attributeValue("id");
        Theme theme = new Theme(id);
        ContextReplace themeContextReplace = new ContextReplace();
        themeContextReplace.addValue("themes-path", null);
        String rootPath = GetterUtil.getString(themeElement.elementText("root-path"), "/");
        rootPath = themeContextReplace.replace(rootPath);
        themeContextReplace.addValue("root-path", rootPath);
        theme.setRootPath(rootPath);
        String templatesPath = GetterUtil.getString(themeElement.elementText("templates-path"), rootPath.concat("/templates"));
        templatesPath = themeContextReplace.replace(templatesPath);
        templatesPath = StringUtil.safePath(templatesPath);
        themeContextReplace.addValue("templates-path", templatesPath);
        theme.setTemplatesPath(templatesPath);
        String cssPath = GetterUtil.getString(themeElement.elementText("css-path"), rootPath.concat("/css"));
        cssPath = themeContextReplace.replace(cssPath);
        cssPath = StringUtil.safePath(cssPath);
        themeContextReplace.addValue("css-path", cssPath);
        theme.setCssPath(cssPath);
        String imagesPath = GetterUtil.getString(themeElement.elementText("images-path"), rootPath.concat("/images"));
        imagesPath = themeContextReplace.replace(imagesPath);
        imagesPath = StringUtil.safePath(imagesPath);
        themeContextReplace.addValue("images-path", imagesPath);
        theme.setImagesPath(imagesPath);
        String javaScriptPath = GetterUtil.getString(themeElement.elementText("javascript-path"), rootPath.concat("/js"));
        javaScriptPath = themeContextReplace.replace(javaScriptPath);
        javaScriptPath = StringUtil.safePath(javaScriptPath);
        themeContextReplace.addValue("javascript-path", javaScriptPath);
        theme.setJavaScriptPath(javaScriptPath);
        String templateExtension = GetterUtil.getString(themeElement.elementText("template-extension"), this.themeType);
        theme.setTemplateExtension(templateExtension);
        return theme;
    }

    protected Theme readTheme(String themeId, File liferayLookAndFeelXml) throws Exception {
        if (liferayLookAndFeelXml != null && liferayLookAndFeelXml.exists()) {
            Document document = SAXReaderUtil.read(liferayLookAndFeelXml, false);
            Element rootElement = document.getRootElement();
            List themeElements = rootElement.elements("theme");
            for (Element themeElement : themeElements) {
                String id = themeElement.attributeValue("id");
                if (Validator.isNotNull(themeId) && !themeId.equals(id)) continue;
                return this.readTheme(themeElement);
            }
        }
        Theme theme = new Theme(themeId);
        theme.setCssPath("/css");
        theme.setImagesPath("/images");
        theme.setJavaScriptPath("/js");
        theme.setRootPath("/");
        theme.setTemplateExtension(this.themeType);
        theme.setTemplatesPath("/templates");
        return theme;
    }
}

