/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.deser;

import akka.NotUsed;
import akka.util.ByteString;
import com.lightbend.lagom.javadsl.api.deser.DeserializationException;
import com.lightbend.lagom.javadsl.api.deser.MessageSerializer;
import com.lightbend.lagom.javadsl.api.deser.SerializationException;
import com.lightbend.lagom.javadsl.api.deser.StrictMessageSerializer;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import com.lightbend.lagom.javadsl.api.transport.NotAcceptable;
import com.lightbend.lagom.javadsl.api.transport.UnsupportedMediaType;
import java.util.List;
import java.util.Optional;

public class MessageSerializers {
    public static final StrictMessageSerializer<NotUsed> NOT_USED = new StrictMessageSerializer<NotUsed>(){

        @Override
        public MessageSerializer.NegotiatedSerializer<NotUsed, ByteString> serializerForRequest() {
            return notUsed -> ByteString.empty();
        }

        @Override
        public MessageSerializer.NegotiatedDeserializer<NotUsed, ByteString> deserializer(MessageProtocol messageProtocol) throws SerializationException {
            return byteString -> NotUsed.getInstance();
        }

        @Override
        public MessageSerializer.NegotiatedSerializer<NotUsed, ByteString> serializerForResponse(List<MessageProtocol> list) {
            return notUsed -> ByteString.empty();
        }

        @Override
        public boolean isUsed() {
            return false;
        }
    };
    public static final StrictMessageSerializer<String> STRING = new StrictMessageSerializer<String>(){
        MessageProtocol defaultProtocol = new MessageProtocol(Optional.of("text/plain"), Optional.of("utf-8"), Optional.empty());

        @Override
        public MessageSerializer.NegotiatedSerializer<String, ByteString> serializerForRequest() {
            return new StringSerializer(this.defaultProtocol);
        }

        @Override
        public MessageSerializer.NegotiatedDeserializer<String, ByteString> deserializer(MessageProtocol messageProtocol) throws UnsupportedMediaType {
            if (messageProtocol.contentType().orElse("text/plain").equals("text/plain")) {
                return new StringDeserializer(messageProtocol.charset().orElse("utf-8"));
            }
            throw new UnsupportedMediaType(messageProtocol, this.defaultProtocol);
        }

        @Override
        public MessageSerializer.NegotiatedSerializer<String, ByteString> serializerForResponse(List<MessageProtocol> list) throws NotAcceptable {
            if (list.isEmpty()) {
                return this.serializerForRequest();
            }
            for (MessageProtocol messageProtocol : list) {
                String string = messageProtocol.contentType().orElse("text/plain");
                if (!string.equals("text/plain") && !string.equals("text/*") && !string.equals("*/*") && !string.equals("*")) continue;
                return new StringSerializer(messageProtocol.withContentType("text/plain"));
            }
            throw new NotAcceptable(list, this.defaultProtocol);
        }

        class StringDeserializer
        implements MessageSerializer.NegotiatedDeserializer<String, ByteString> {
            private final String charset;

            StringDeserializer(String string) {
                this.charset = string;
            }

            @Override
            public String deserialize(ByteString byteString) throws DeserializationException {
                return byteString.decodeString(this.charset);
            }
        }

        class StringSerializer
        implements MessageSerializer.NegotiatedSerializer<String, ByteString> {
            private final MessageProtocol protocol;

            StringSerializer(MessageProtocol messageProtocol) {
                this.protocol = messageProtocol;
            }

            @Override
            public MessageProtocol protocol() {
                return this.protocol;
            }

            @Override
            public ByteString serialize(String string) throws SerializationException {
                return ByteString.fromString((String)string, (String)this.protocol.charset().orElse("utf-8"));
            }
        }
    };

    private MessageSerializers() {
    }
}

