/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.security;

import com.lightbend.lagom.javadsl.api.security.ServicePrincipal;
import com.lightbend.lagom.javadsl.api.transport.HeaderFilter;
import com.lightbend.lagom.javadsl.api.transport.RequestHeader;
import com.lightbend.lagom.javadsl.api.transport.ResponseHeader;
import java.security.Principal;
import java.util.Optional;

public class UserAgentHeaderFilter
implements HeaderFilter {
    @Override
    public RequestHeader transformClientRequest(RequestHeader requestHeader) {
        if (requestHeader.principal().isPresent()) {
            Principal principal = requestHeader.principal().get();
            if (principal instanceof ServicePrincipal) {
                String string = ((ServicePrincipal)principal).serviceName();
                return requestHeader.withHeader("User-Agent", string);
            }
            return requestHeader;
        }
        return requestHeader;
    }

    @Override
    public RequestHeader transformServerRequest(RequestHeader requestHeader) {
        Optional<String> optional = requestHeader.getHeader("User-Agent");
        if (optional.isPresent()) {
            return requestHeader.withPrincipal(ServicePrincipal.forServiceNamed(optional.get()));
        }
        return requestHeader;
    }

    @Override
    public ResponseHeader transformServerResponse(ResponseHeader responseHeader, RequestHeader requestHeader) {
        return responseHeader;
    }

    @Override
    public ResponseHeader transformClientResponse(ResponseHeader responseHeader, RequestHeader requestHeader) {
        return responseHeader;
    }
}

