/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.transport;

import com.lightbend.lagom.javadsl.api.transport.MessageHeader;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import com.lightbend.lagom.javadsl.api.transport.Method;
import java.net.URI;
import java.security.Principal;
import java.util.Locale;
import java.util.Optional;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.pcollections.PSequence;
import org.pcollections.TreePVector;

public final class RequestHeader
extends MessageHeader {
    private final Method method;
    private final URI uri;
    private final PSequence<MessageProtocol> acceptedResponseProtocols;
    private final Optional<Principal> principal;
    public static final RequestHeader DEFAULT = new RequestHeader(Method.GET, URI.create("/"), new MessageProtocol(), (PSequence<MessageProtocol>)TreePVector.empty(), Optional.empty(), (PMap<String, PSequence<String>>)HashTreePMap.empty());

    private RequestHeader(Method method, URI uRI, MessageProtocol messageProtocol, PSequence<MessageProtocol> pSequence, Optional<Principal> optional, PMap<String, PSequence<String>> pMap, PMap<String, PSequence<String>> pMap2) {
        super(messageProtocol, pMap, pMap2);
        this.method = method;
        this.uri = uRI;
        this.acceptedResponseProtocols = pSequence;
        this.principal = optional;
    }

    public RequestHeader(Method method, URI uRI, MessageProtocol messageProtocol, PSequence<MessageProtocol> pSequence, Optional<Principal> optional, PMap<String, PSequence<String>> pMap) {
        super(messageProtocol, pMap);
        this.method = method;
        this.uri = uRI;
        this.acceptedResponseProtocols = pSequence;
        this.principal = optional;
    }

    public Method method() {
        return this.method;
    }

    public URI uri() {
        return this.uri;
    }

    public PSequence<MessageProtocol> acceptedResponseProtocols() {
        return this.acceptedResponseProtocols;
    }

    public Optional<Principal> principal() {
        return this.principal;
    }

    public RequestHeader withMethod(Method method) {
        return new RequestHeader(method, this.uri, this.protocol, this.acceptedResponseProtocols, this.principal, (PMap<String, PSequence<String>>)this.headers, (PMap<String, PSequence<String>>)this.lowercaseHeaders);
    }

    public RequestHeader withUri(URI uRI) {
        return new RequestHeader(this.method, uRI, this.protocol, this.acceptedResponseProtocols, this.principal, (PMap<String, PSequence<String>>)this.headers, (PMap<String, PSequence<String>>)this.lowercaseHeaders);
    }

    @Override
    public RequestHeader withProtocol(MessageProtocol messageProtocol) {
        return new RequestHeader(this.method, this.uri, messageProtocol, this.acceptedResponseProtocols, this.principal, (PMap<String, PSequence<String>>)this.headers, (PMap<String, PSequence<String>>)this.lowercaseHeaders);
    }

    public RequestHeader withAcceptedResponseProtocols(PSequence<MessageProtocol> pSequence) {
        return new RequestHeader(this.method, this.uri, this.protocol, pSequence, this.principal, (PMap<String, PSequence<String>>)this.headers, (PMap<String, PSequence<String>>)this.lowercaseHeaders);
    }

    public RequestHeader withPrincipal(Principal principal) {
        return new RequestHeader(this.method, this.uri, this.protocol, this.acceptedResponseProtocols, Optional.ofNullable(principal), (PMap<String, PSequence<String>>)this.headers, (PMap<String, PSequence<String>>)this.lowercaseHeaders);
    }

    public RequestHeader clearPrincipal() {
        return new RequestHeader(this.method, this.uri, this.protocol, this.acceptedResponseProtocols, Optional.empty(), (PMap<String, PSequence<String>>)this.headers, (PMap<String, PSequence<String>>)this.lowercaseHeaders);
    }

    @Override
    public RequestHeader replaceAllHeaders(PMap<String, PSequence<String>> pMap) {
        return new RequestHeader(this.method, this.uri, this.protocol, this.acceptedResponseProtocols, this.principal, pMap);
    }

    @Override
    public RequestHeader withHeader(String string, String string2) {
        return new RequestHeader(this.method, this.uri, this.protocol, this.acceptedResponseProtocols, this.principal, (PMap<String, PSequence<String>>)this.headers.plus((Object)string, (Object)TreePVector.singleton((Object)string2)), (PMap<String, PSequence<String>>)this.lowercaseHeaders.plus((Object)string.toLowerCase(Locale.ENGLISH), (Object)TreePVector.singleton((Object)string2)));
    }

    public String toString() {
        return "RequestHeader{method=" + this.method + ", uri=" + this.uri + ", protocol=" + this.protocol + ", acceptedResponseProtocols=" + this.acceptedResponseProtocols + ", principal=" + this.principal + ", headers=" + this.headers + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RequestHeader)) {
            return false;
        }
        RequestHeader requestHeader = (RequestHeader)object;
        if (!this.method.equals(requestHeader.method)) {
            return false;
        }
        if (!this.uri.equals(requestHeader.uri)) {
            return false;
        }
        if (!this.protocol.equals(requestHeader.protocol)) {
            return false;
        }
        if (!this.acceptedResponseProtocols.equals(requestHeader.acceptedResponseProtocols)) {
            return false;
        }
        if (!this.principal.equals(requestHeader.principal)) {
            return false;
        }
        return this.lowercaseHeaders.equals(requestHeader.lowercaseHeaders);
    }

    public int hashCode() {
        int n = this.method.hashCode();
        n = 31 * n + this.uri.hashCode();
        n = 31 * n + this.protocol.hashCode();
        n = 31 * n + this.acceptedResponseProtocols.hashCode();
        n = 31 * n + this.principal.hashCode();
        n = 31 * n + this.lowercaseHeaders.hashCode();
        return n;
    }
}

