/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.mongodb.replicaset.ConfigurationDocument;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import java.util.Set;

public class MongoDbCommands {
    private static final String REPL_SET_GET_STATUS_COMMAND = "replSetGetStatus";
    private static final String REPL_SET_INITIATE_COMMAND = "replSetInitiate";
    private static final String RECONFIG_COMMAND = "replSetReconfig";
    private static final String ADD_SHARD_COMMAND = "addshard";
    private static final String ENABLE_SHARDING_COMMAND = "enablesharding";
    private static final String SHARD_COLLECTION_COMMAND = "shardcollection";
    private static final String LIST_SHARDS_COMMAND = "listShards";

    private MongoDbCommands() {
    }

    public static DBObject replicaSetGetStatus(Mongo mongoClient) {
        return mongoClient.getDB("admin").command((DBObject)new BasicDBObject(REPL_SET_GET_STATUS_COMMAND, (Object)1));
    }

    public static CommandResult shardCollection(Mongo mongoClient, String collectionWithDatabase, DBObject shardKey) {
        DB adminDb = MongoDbCommands.getAdminDatabase(mongoClient);
        BasicDBObject basicDBObject = new BasicDBObject(SHARD_COLLECTION_COMMAND, (Object)collectionWithDatabase);
        basicDBObject.put((Object)"key", (Object)shardKey);
        return adminDb.command((DBObject)basicDBObject);
    }

    public static CommandResult enableSharding(MongoClient mongoClient, String database) {
        DB adminDb = MongoDbCommands.getAdminDatabase((Mongo)mongoClient);
        return adminDb.command((DBObject)new BasicDBObject(ENABLE_SHARDING_COMMAND, (Object)database));
    }

    public static CommandResult listShards(MongoClient mongoClient) {
        DB adminDb = MongoDbCommands.getAdminDatabase((Mongo)mongoClient);
        return adminDb.command((DBObject)new BasicDBObject(LIST_SHARDS_COMMAND, (Object)1));
    }

    public static void addShard(MongoClient mongoClient, Set<String> shards) {
        DB adminDb = MongoDbCommands.getAdminDatabase((Mongo)mongoClient);
        for (String shardUri : shards) {
            adminDb.command((DBObject)new BasicDBObject(ADD_SHARD_COMMAND, (Object)shardUri));
        }
    }

    public static CommandResult replicaSetInitiate(MongoClient mongoClient, ConfigurationDocument configurationDocument) {
        DB adminDb = MongoDbCommands.getAdminDatabase((Mongo)mongoClient);
        BasicDBObject command = new BasicDBObject(REPL_SET_INITIATE_COMMAND, (Object)configurationDocument.getConfiguration());
        return adminDb.command((DBObject)command);
    }

    private static DB getAdminDatabase(Mongo mongoClient) {
        DB adminDb = mongoClient.getDB("admin");
        return adminDb;
    }

    public static CommandResult replSetReconfig(MongoClient mongoClient, ConfigurationDocument configurationDocument) {
        DB adminDb = MongoDbCommands.getAdminDatabase((Mongo)mongoClient);
        BasicDBObject command = new BasicDBObject(RECONFIG_COMMAND, (Object)configurationDocument.getConfiguration());
        return adminDb.command((DBObject)command);
    }

    public static void shutdown(String host, int port) {
        try (MongoClient mongo = null;){
            mongo = new MongoClient(host, port);
            DB db = mongo.getDB("admin");
            CommandResult shutdownResult = db.command((DBObject)new BasicDBObject("shutdown", (Object)1));
            shutdownResult.throwOnError();
        }
    }
}

