/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb.replicaset;

import ch.lambdaj.Lambda;
import com.lordofthejars.nosqlunit.mongodb.ManagedMongoDbLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ConfigurationDocument;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ReplicaSetGroup {
    private static final int DEFAULT_DEFAULT_CONNECTION_INDEX = 0;
    private List<ManagedMongoDbLifecycleManager> servers = new LinkedList<ManagedMongoDbLifecycleManager>();
    private ConfigurationDocument configurationDocument;
    private String username;
    private String password;
    private int connectionIndex = 0;

    public void setConfigurationDocument(ConfigurationDocument configurationDocument) {
        this.configurationDocument = configurationDocument;
    }

    public void addServer(ManagedMongoDbLifecycleManager server) {
        this.servers.add(server);
    }

    public ConfigurationDocument getConfiguration() {
        return this.configurationDocument;
    }

    public List<ManagedMongoDbLifecycleManager> getServers() {
        return this.servers;
    }

    public ManagedMongoDbLifecycleManager getDefaultConnection() {
        return this.servers.get(this.connectionIndex);
    }

    public void setConnectionIndex(int connectionIndex) {
        this.connectionIndex = connectionIndex;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticationSet() {
        return this.username != null && this.password != null;
    }

    public ManagedMongoDbLifecycleManager getStoppedServer(int port) {
        return (ManagedMongoDbLifecycleManager)((Object)Lambda.selectFirst(this.servers, (Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).getPort(), (Matcher)CoreMatchers.is((Object)port)).and((Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).isReady(), (Matcher)CoreMatchers.is((Object)false)))));
    }

    public ManagedMongoDbLifecycleManager getStartedServer(int port) {
        return (ManagedMongoDbLifecycleManager)((Object)Lambda.selectFirst(this.servers, (Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).getPort(), (Matcher)CoreMatchers.is((Object)port)).and((Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).isReady(), (Matcher)CoreMatchers.is((Object)true)))));
    }

    public int numberOfStartedServers() {
        return this.servers.size() - this.numberOfStoppedServers();
    }

    public int numberOfStoppedServers() {
        int numberOfStoppedServers = 0;
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : this.servers) {
            if (managedMongoDbLifecycleManager.isReady()) continue;
            ++numberOfStoppedServers;
        }
        return numberOfStoppedServers;
    }

    public String getReplicaSetName() {
        return this.configurationDocument.getReplicaSetName();
    }
}

