/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.mongodb.MongoDbCommands;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConnectionCallback;
import com.lordofthejars.nosqlunit.mongodb.MongoInsertionStrategy;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DefaultInsertionStrategy
implements MongoInsertionStrategy {
    private static final String SHARD_KEY_PATTERN = "shard-key-pattern";
    private static final String INDEXES = "indexes";
    private static final String INDEX = "index";
    private static final String INDEX_OPTIONS = "options";
    private static final String DATA = "data";
    private static final String DATABASE_COLLECTION_SEPARATOR = ".";

    public void insert(MongoDbConnectionCallback connection, InputStream dataset) throws IOException {
        String jsonData = this.loadContentFromInputStream(dataset);
        Document parsedData = this.parseData(jsonData);
        this.insertParsedData(parsedData, connection.db(), connection.mongoClient());
    }

    private String loadContentFromInputStream(InputStream inputStreamContent) throws IOException {
        return IOUtils.readFullStream((InputStream)inputStreamContent);
    }

    private Document parseData(String jsonData) throws IOException {
        Document parsedData = Document.parse((String)jsonData);
        return parsedData;
    }

    private void insertParsedData(Document parsedData, MongoDatabase mongoDb, MongoClient mongoClient) {
        Set collectionaNames = parsedData.keySet();
        for (String collectionName : collectionaNames) {
            Object document = parsedData.get((Object)collectionName, Object.class);
            if (!this.isDataDirectly(document)) {
                Document doc = (Document)document;
                if (this.isShardedCollection(doc)) {
                    this.insertShardKeyPattern(mongoDb, mongoClient, collectionName, doc);
                }
                if (this.isIndexes(doc)) {
                    this.insertIndexes(mongoDb, collectionName, doc);
                }
            }
            this.insertCollection(parsedData, mongoDb, collectionName);
        }
    }

    private void insertCollection(Document parsedData, MongoDatabase mongoDb, String collectionName) {
        List data;
        if (this.isDataDirectly(parsedData.get((Object)collectionName))) {
            data = (List)parsedData.get((Object)collectionName, List.class);
        } else {
            Document collection = (Document)parsedData.get((Object)collectionName, Document.class);
            data = (List)collection.get((Object)DATA, List.class);
        }
        this.insertData(data, mongoDb, collectionName);
    }

    private void insertIndexes(MongoDatabase mongoDb, String collectionName, Document collection) {
        MongoCollection indexedCollection = mongoDb.getCollection(collectionName);
        List indexes = (List)collection.get((Object)INDEXES, List.class);
        for (Document index : indexes) {
            Document indexKeys = (Document)index.get((Object)INDEX, Document.class);
            if (index.containsKey((Object)INDEX_OPTIONS)) {
                Document indexOptions = (Document)index.get((Object)INDEX_OPTIONS, Document.class);
                indexedCollection.createIndex((Bson)indexKeys, this.toIndexOptions(indexOptions));
                continue;
            }
            indexedCollection.createIndex((Bson)indexKeys);
        }
    }

    private IndexOptions toIndexOptions(Document indexOptions) {
        IndexOptions mongoDbIndexOptions = new IndexOptions();
        if (indexOptions.containsKey((Object)"background")) {
            mongoDbIndexOptions.background(indexOptions.getBoolean((Object)"background").booleanValue());
        }
        if (indexOptions.containsKey((Object)"unique")) {
            mongoDbIndexOptions.unique(indexOptions.getBoolean((Object)"unique").booleanValue());
        }
        if (indexOptions.containsKey((Object)"name")) {
            mongoDbIndexOptions.name(indexOptions.getString((Object)"name"));
        }
        if (indexOptions.containsKey((Object)"sparse")) {
            mongoDbIndexOptions.sparse(indexOptions.getBoolean((Object)"sparse").booleanValue());
        }
        if (indexOptions.containsKey((Object)"expireAfterSeconds")) {
            mongoDbIndexOptions.expireAfter(indexOptions.getLong((Object)"expireAfterSeconds"), TimeUnit.SECONDS);
        }
        if (indexOptions.containsKey((Object)"version")) {
            mongoDbIndexOptions.version(indexOptions.getInteger((Object)"version"));
        }
        if (indexOptions.containsKey((Object)"weights")) {
            mongoDbIndexOptions.weights((Bson)indexOptions.get((Object)"weights", Bson.class));
        }
        if (indexOptions.containsKey((Object)"defaultLanguage")) {
            mongoDbIndexOptions.defaultLanguage(indexOptions.getString((Object)"defaultLanguage"));
        }
        if (indexOptions.containsKey((Object)"languageOverride")) {
            mongoDbIndexOptions.languageOverride(indexOptions.getString((Object)"languageOverride"));
        }
        if (indexOptions.containsKey((Object)"textVersion")) {
            mongoDbIndexOptions.textVersion(indexOptions.getInteger((Object)"textVersion"));
        }
        if (indexOptions.containsKey((Object)"sphereVersion")) {
            mongoDbIndexOptions.sphereVersion(indexOptions.getInteger((Object)"sphereVersion"));
        }
        if (indexOptions.containsKey((Object)"bits")) {
            mongoDbIndexOptions.bits(indexOptions.getInteger((Object)"bits"));
        }
        if (indexOptions.containsKey((Object)"min")) {
            mongoDbIndexOptions.min(indexOptions.getDouble((Object)"min"));
        }
        if (indexOptions.containsKey((Object)"max")) {
            mongoDbIndexOptions.max(indexOptions.getDouble((Object)"max"));
        }
        if (indexOptions.containsKey((Object)"bucketSize")) {
            mongoDbIndexOptions.bucketSize(indexOptions.getDouble((Object)"bucketSize"));
        }
        if (indexOptions.containsKey((Object)"storageEngine")) {
            mongoDbIndexOptions.storageEngine((Bson)indexOptions.get((Object)"storageEngine", Bson.class));
        }
        if (indexOptions.containsKey((Object)"partialFilterExpression")) {
            mongoDbIndexOptions.partialFilterExpression((Bson)indexOptions.get((Object)"partialFilterExpression", Bson.class));
        }
        return mongoDbIndexOptions;
    }

    private void insertShardKeyPattern(MongoDatabase mongoDb, MongoClient mongoClient, String collectionName, Document collection) {
        String databaseName = mongoDb.getName();
        String collectionWithDatabase = databaseName + DATABASE_COLLECTION_SEPARATOR + collectionName;
        Document shardKeys = this.shardKeys(collection);
        MongoDbCommands.shardCollection(mongoClient, collectionWithDatabase, shardKeys);
    }

    private Document shardKeys(Document collection) {
        List shards = (List)collection.get((Object)SHARD_KEY_PATTERN, List.class);
        Document document = new Document();
        for (Object dbObject : shards) {
            document.append(dbObject.toString(), (Object)1);
        }
        return document;
    }

    private void insertData(List<Document> dataObjects, MongoDatabase mongoDb, String collectionName) {
        MongoCollection dbCollection = mongoDb.getCollection(collectionName);
        for (Document dataObject : dataObjects) {
            dbCollection.insertOne((Object)dataObject);
        }
    }

    private boolean isDataDirectly(Object object) {
        return List.class.isAssignableFrom(object.getClass());
    }

    private boolean isIndexes(Document document) {
        return document.containsKey((Object)INDEXES);
    }

    private boolean isShardedCollection(Document document) {
        return document.containsKey((Object)SHARD_KEY_PATTERN);
    }
}

