/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.github.fakemongo.Fongo;
import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.EmbeddedMongoInstancesFactory;
import com.lordofthejars.nosqlunit.mongodb.InMemoryMongoDb;
import com.mongodb.MongoClient;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMongoDbLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryMongoDb.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final int PORT = 27017;
    public static final String INMEMORY_MONGO_TARGET_PATH = "target" + File.separatorChar + "mongo-data" + File.separatorChar + "impermanent-db";
    private String targetPath = INMEMORY_MONGO_TARGET_PATH;

    public String getHost() {
        return LOCALHOST + this.targetPath;
    }

    public int getPort() {
        return 27017;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting EmbeddedInMemory MongoDb instance.");
        EmbeddedMongoInstancesFactory.getInstance().addEmbeddedInstance((Object)this.fongo(this.targetPath), this.targetPath);
        LOGGER.info("Started EmbeddedInMemory MongoDb instance.");
    }

    private MongoClient fongo(String targetPath) {
        Fongo fongo = new Fongo(targetPath);
        return fongo.getMongo();
    }

    public void doStop() {
        LOGGER.info("Stopping EmbeddedInMemory MongoDb instance.");
        EmbeddedMongoInstancesFactory.getInstance().removeEmbeddedInstance(this.targetPath);
        LOGGER.info("Stopped EmbeddedInMemory MongoDb instance.");
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }
}

