/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.mongodb.MongoDbConfiguration;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.Arrays;

public class MongoDbConfigurationBuilder {
    private final MongoDbConfiguration mongoDbConfiguration = new MongoDbConfiguration();

    public static MongoDbConfigurationBuilder mongoDb() {
        return new MongoDbConfigurationBuilder();
    }

    private MongoDbConfigurationBuilder() {
    }

    public MongoDbConfiguration build() {
        MongoClient mongo = null;
        if (this.mongoDbConfiguration.isAuthenticateParametersSet()) {
            MongoCredential credential = MongoCredential.createCredential((String)this.mongoDbConfiguration.getUsername(), (String)this.mongoDbConfiguration.getDatabaseName(), (char[])this.mongoDbConfiguration.getPassword().toCharArray());
            mongo = new MongoClient(new ServerAddress(this.mongoDbConfiguration.getHost(), this.mongoDbConfiguration.getPort()), Arrays.asList(credential));
        } else {
            mongo = new MongoClient(this.mongoDbConfiguration.getHost(), this.mongoDbConfiguration.getPort());
        }
        this.mongoDbConfiguration.setMongo(mongo);
        return this.mongoDbConfiguration;
    }

    public MongoDbConfigurationBuilder databaseName(String databaseName) {
        this.mongoDbConfiguration.setDatabaseName(databaseName);
        return this;
    }

    public MongoDbConfigurationBuilder port(int port) {
        this.mongoDbConfiguration.setPort(port);
        return this;
    }

    public MongoDbConfigurationBuilder username(String username) {
        this.mongoDbConfiguration.setUsername(username);
        return this;
    }

    public MongoDbConfigurationBuilder password(String password) {
        this.mongoDbConfiguration.setPassword(password);
        return this;
    }

    public MongoDbConfigurationBuilder host(String host) {
        this.mongoDbConfiguration.setHost(host);
        return this;
    }

    public MongoDbConfigurationBuilder connectionIdentifier(String identifier) {
        this.mongoDbConfiguration.setConnectionIdentifier(identifier);
        return this;
    }
}

