/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb.shard;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.ManagedMongoDbLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.MongoDbCommands;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ReplicaSetManagedMongoDb;
import com.lordofthejars.nosqlunit.mongodb.shard.ManagedMongosLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.shard.ShardedGroup;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedManagedMongoDb
extends ExternalResource {
    private static final String HOST_PORT_SEPARATOR = ":";
    private static final Logger LOGGER = LoggerFactory.getLogger(ShardedManagedMongoDb.class);
    private ShardedGroup shardedGroup;

    protected ShardedManagedMongoDb(ShardedGroup shardedGroup) {
        this.shardedGroup = shardedGroup;
    }

    public void shutdownServer(int port) {
        AbstractLifecycleManager stoppingServer = this.shardedGroup.getStoppingServer(port);
        if (stoppingServer != null) {
            stoppingServer.stopEngine();
        }
    }

    public void startupServer(int port) throws Throwable {
        AbstractLifecycleManager startingServer = this.shardedGroup.getStartingServer(port);
        if (startingServer != null) {
            startingServer.startEngine();
        }
    }

    private boolean isServerStarted(AbstractLifecycleManager abstractLifecycleManager) {
        return abstractLifecycleManager.isReady();
    }

    private boolean isServerStopped(AbstractLifecycleManager abstractLifecycleManager) {
        return !abstractLifecycleManager.isReady();
    }

    protected void before() throws Throwable {
        this.wakeUpShards();
        this.wakeUpConfigs();
        this.wakeUpMongos();
        this.registerAllShards();
    }

    private Set<String> shardsUri() {
        List<ManagedMongoDbLifecycleManager> shards = this.shardedGroup.getShards();
        HashSet<String> shardsUri = new HashSet<String>();
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : shards) {
            shardsUri.add(this.getUri(managedMongoDbLifecycleManager));
        }
        return shardsUri;
    }

    private String getUri(ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager) {
        return managedMongoDbLifecycleManager.getHost() + HOST_PORT_SEPARATOR + Integer.toString(managedMongoDbLifecycleManager.getPort());
    }

    private void wakeUpMongos() throws Throwable {
        LOGGER.info("Starting Mongos");
        List<ManagedMongosLifecycleManager> mongos = this.shardedGroup.getMongos();
        for (ManagedMongosLifecycleManager managedMongosLifecycleManager : mongos) {
            if (!this.isServerStopped(managedMongosLifecycleManager)) continue;
            managedMongosLifecycleManager.startEngine();
        }
        LOGGER.info("Started Mongos");
    }

    private void wakeUpConfigs() throws Throwable {
        LOGGER.info("Starting Configs");
        List<ManagedMongoDbLifecycleManager> configs = this.shardedGroup.getConfigs();
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : configs) {
            if (!this.isServerStopped(managedMongoDbLifecycleManager)) continue;
            managedMongoDbLifecycleManager.startEngine();
        }
        LOGGER.info("Started Configs");
    }

    private void wakeUpShards() throws Throwable {
        if (this.shardedGroup.isShardsAndReplicSetShardsMixed()) {
            throw new IllegalArgumentException("Cannot mix shards servers with replica set shards servers.");
        }
        if (this.shardedGroup.isOnlyShards()) {
            this.wakeUpShardsServers();
        } else if (this.shardedGroup.isOnlyReplicaSetShards()) {
            this.wakeUpReplicaSetShardsServers();
        }
    }

    private void wakeUpReplicaSetShardsServers() throws Throwable {
        LOGGER.info("Starting ReplicaSet Shards");
        List<ReplicaSetManagedMongoDb> replicaSets = this.shardedGroup.getReplicaSets();
        for (ReplicaSetManagedMongoDb replicaSetManagedMongoDb : replicaSets) {
            replicaSetManagedMongoDb.startAllReplicaSet();
        }
        LOGGER.info("Started ReplicaSet Shards");
    }

    private void wakeUpShardsServers() throws Throwable {
        LOGGER.info("Starting Shards");
        List<ManagedMongoDbLifecycleManager> shards = this.shardedGroup.getShards();
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : shards) {
            if (!this.isServerStopped(managedMongoDbLifecycleManager)) continue;
            managedMongoDbLifecycleManager.startEngine();
        }
        LOGGER.info("Started Shards");
    }

    private void registerAllShards() throws UnknownHostException {
        if (this.shardedGroup.isShardsAndReplicSetShardsMixed()) {
            throw new IllegalArgumentException("Cannot mix shards servers with replica set shards servers.");
        }
        try (MongoClient mongosMongoClient = null;){
            mongosMongoClient = this.getMongosMongoClient();
            if (this.shardedGroup.isOnlyShards()) {
                this.registerShardServers(mongosMongoClient);
            } else if (this.shardedGroup.isOnlyReplicaSetShards()) {
                this.registerReplicaSetShardServers(mongosMongoClient);
            }
        }
    }

    private void registerReplicaSetShardServers(MongoClient mongosMongoClient) {
        Set<String> replicaSetShardsConfig = this.buildReplicaSetShardAddingCommand();
        MongoDbCommands.addShard(mongosMongoClient, replicaSetShardsConfig);
    }

    private Set<String> buildReplicaSetShardAddingCommand() {
        HashSet<String> replicaSetShardsConfig = new HashSet<String>();
        for (ReplicaSetManagedMongoDb replicaSetManagedMongoDb : this.shardedGroup.getReplicaSets()) {
            List<ManagedMongoDbLifecycleManager> replicaSetServers = replicaSetManagedMongoDb.getReplicaSetServers();
            replicaSetShardsConfig.add(this.shardUri(replicaSetManagedMongoDb.replicaSetName(), replicaSetServers));
        }
        return replicaSetShardsConfig;
    }

    private void registerShardServers(MongoClient mongosMongoClient) {
        MongoDbCommands.addShard(mongosMongoClient, this.shardsUri());
    }

    private String shardUri(String replicaSetName, List<ManagedMongoDbLifecycleManager> managedMongoDbLifecycleManagers) {
        StringBuilder stringBuilder = new StringBuilder(replicaSetName);
        stringBuilder.append("/");
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : managedMongoDbLifecycleManagers) {
            stringBuilder.append(this.getUri(managedMongoDbLifecycleManager));
            stringBuilder.append(", ");
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 2);
    }

    private MongoClient getMongosMongoClient() throws UnknownHostException {
        ManagedMongosLifecycleManager firstMongosServer = this.shardedGroup.getFirstMongosServer();
        if (this.shardedGroup.isAuthenticationSet()) {
            MongoCredential credential = MongoCredential.createCredential((String)this.shardedGroup.getUsername(), (String)"admin", (char[])this.shardedGroup.getPassword().toCharArray());
            return new MongoClient(new ServerAddress(firstMongosServer.getHost(), firstMongosServer.getPort()), Arrays.asList(credential));
        }
        return new MongoClient(firstMongosServer.getHost(), firstMongosServer.getPort());
    }

    protected void after() {
        this.shutdownMongos();
        this.shutdownConfigs();
        this.shutdownShards();
        this.shutdownReplicaSetShards();
    }

    private void shutdownReplicaSetShards() {
        LOGGER.info("Stopping ReplicaSet Shards");
        List<ReplicaSetManagedMongoDb> replicaSets = this.shardedGroup.getReplicaSets();
        for (ReplicaSetManagedMongoDb replicaSetManagedMongoDb : replicaSets) {
            replicaSetManagedMongoDb.stopAllReplicaSet();
        }
        LOGGER.info("Stopped ReplicaSet Shards");
    }

    private void shutdownMongos() {
        LOGGER.info("Stopping Mongos");
        List<ManagedMongosLifecycleManager> mongos = this.shardedGroup.getMongos();
        for (ManagedMongosLifecycleManager managedMongosLifecycleManager : mongos) {
            if (!this.isServerStarted(managedMongosLifecycleManager)) continue;
            managedMongosLifecycleManager.stopEngine();
        }
        LOGGER.info("Stopped Mongos");
    }

    private void shutdownConfigs() {
        LOGGER.info("Stopping Configs");
        List<ManagedMongoDbLifecycleManager> configs = this.shardedGroup.getConfigs();
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : configs) {
            if (!this.isServerStarted(managedMongoDbLifecycleManager)) continue;
            managedMongoDbLifecycleManager.stopEngine();
        }
        LOGGER.info("Stopped Configs");
    }

    private void shutdownShards() {
        LOGGER.info("Stopping Shards");
        List<ManagedMongoDbLifecycleManager> shards = this.shardedGroup.getShards();
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : shards) {
            if (!this.isServerStarted(managedMongoDbLifecycleManager)) continue;
            managedMongoDbLifecycleManager.stopEngine();
        }
        LOGGER.info("Stopped Shards");
    }
}

