/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers;

import com.mattunderscore.http.headers.HeaderParser;
import com.mattunderscore.http.headers.QContentType;
import com.mattunderscore.http.headers.UnParsableHeaderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypeParser
implements HeaderParser<QContentType> {
    @Override
    public boolean isCorrectHeader(String header) {
        return "ACCEPT".equals(header.toUpperCase());
    }

    @Override
    public Collection<QContentType> parseAll(String header) throws UnParsableHeaderException {
        if (header == null) {
            throw new UnParsableHeaderException("Null Pointer.");
        }
        ArrayList<QContentType> qCT = new ArrayList<QContentType>();
        if ("".equals(header)) {
            return qCT;
        }
        String[] types = header.split(",");
        for (int i = 0; i < types.length; ++i) {
            QContentType ct = this.parse(types[i].trim());
            if (ct == null) continue;
            qCT.add(ct);
        }
        return qCT;
    }

    @Override
    public QContentType parse(String types) throws UnParsableHeaderException {
        if (types == null) {
            throw new UnParsableHeaderException("Null pointer");
        }
        if ("".equals(types.trim())) {
            throw new UnParsableHeaderException("Empty string");
        }
        String[] typeParts = types.trim().split("/");
        if (typeParts.length == 2) {
            String[] lastParts = typeParts[1].trim().split(";", -1);
            HashMap<String, String> map = new HashMap<String, String>();
            double qualifier = 1.0;
            if (lastParts.length > 1) {
                for (int i = 1; i < lastParts.length; ++i) {
                    String[] extensions = lastParts[i].trim().split("=", -1);
                    if (extensions.length != 2) {
                        throw new UnParsableHeaderException("Invalid parameter.");
                    }
                    if ("q".equals(extensions[0].trim())) {
                        try {
                            qualifier = Double.parseDouble(extensions[1].trim());
                        }
                        catch (NumberFormatException exception) {
                            throw new UnParsableHeaderException("Unable to parse number");
                        }
                        if (!(qualifier < 0.0) && !(qualifier > 1.0)) continue;
                        throw new UnParsableHeaderException("Invalid qualifier range.");
                    }
                    map.put(extensions[0].trim(), extensions[1].trim());
                }
            } else if (lastParts.length == 0) {
                throw new UnParsableHeaderException("Unparsable content type: " + typeParts[1]);
            }
            return new QContentType(typeParts[0].trim(), lastParts[0].trim(), map, qualifier);
        }
        throw new UnParsableHeaderException("Unparsable content type: " + types.trim() + ": " + typeParts.length);
    }
}

