/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers;

import com.mattunderscore.http.headers.HeaderParser;
import com.mattunderscore.http.headers.QEncoding;
import com.mattunderscore.http.headers.UnParsableHeaderException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingParser
implements HeaderParser<QEncoding> {
    @Override
    public boolean isCorrectHeader(String header) {
        return "Accept-Encoding".equalsIgnoreCase(header);
    }

    @Override
    public Collection<QEncoding> parseAll(String header) throws UnParsableHeaderException {
        ArrayList<QEncoding> qEcodings = new ArrayList<QEncoding>();
        String[] types = header.split(",");
        boolean addIdentity = true;
        double smallestQualifier = 10.0;
        for (int i = 0; i < types.length; ++i) {
            QEncoding encoding;
            String fieldElement = types[i].trim();
            if ("".equals(fieldElement) || (encoding = this.parse(fieldElement)) == null) continue;
            if (encoding.sameEncoding(new QEncoding("identity", 1.0))) {
                addIdentity = false;
            } else if (addIdentity && encoding.getQualifier() < smallestQualifier) {
                smallestQualifier = encoding.getQualifier();
            }
            qEcodings.add(encoding);
        }
        if (addIdentity) {
            qEcodings.add(new QEncoding("identity", smallestQualifier / 10.0));
        }
        return qEcodings;
    }

    @Override
    public QEncoding parse(String header) throws UnParsableHeaderException {
        if (header == null) {
            throw new UnParsableHeaderException("Null Pointer.");
        }
        if ("".equals(header.trim())) {
            throw new UnParsableHeaderException("Empty string");
        }
        String[] headers = header.split(";q=");
        if (headers.length == 2) {
            double qualifier = Double.parseDouble(headers[1].trim());
            if (qualifier < 0.0 || qualifier > 1.0) {
                throw new UnParsableHeaderException("Invalid qualifier range.");
            }
            return new QEncoding(headers[0].trim(), qualifier);
        }
        return new QEncoding(headers[0].trim(), 1.0);
    }
}

