/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers;

import com.mattunderscore.http.headers.HeaderParser;
import com.mattunderscore.http.headers.QLanguage;
import com.mattunderscore.http.headers.UnParsableHeaderException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageParser
implements HeaderParser<QLanguage> {
    @Override
    public boolean isCorrectHeader(String header) {
        return "ACCEPT-LANGUAGE".equals(header.toUpperCase());
    }

    @Override
    public Collection<QLanguage> parseAll(String header) throws UnParsableHeaderException {
        if (header == null) {
            throw new UnParsableHeaderException("Null Pointer.");
        }
        ArrayList<QLanguage> qL = new ArrayList<QLanguage>();
        if ("".equals(header)) {
            return qL;
        }
        String[] types = header.split(",", -1);
        for (int i = 0; i < types.length; ++i) {
            QLanguage lang = this.parse(types[i].trim());
            if (lang == null) continue;
            qL.add(lang);
        }
        return qL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public QLanguage parse(String types) throws UnParsableHeaderException {
        if (types == null) {
            throw new UnParsableHeaderException("Null Pointer.");
        }
        if ("".equals(types.trim())) {
            throw new UnParsableHeaderException("Empty string");
        }
        String[] langParts = types.trim().split("-");
        double qualifier = 1.0;
        if (langParts.length == 1) {
            String[] lastParts = langParts[0].trim().split(";");
            if (lastParts.length == 1) {
                qualifier = 1.0;
                return new QLanguage(lastParts[0].trim(), "*", qualifier);
            }
            if (lastParts.length != 2) throw new UnParsableHeaderException("Incorrect number of parts.");
            String[] qualifierParts = lastParts[1].trim().split("=");
            if (qualifierParts.length != 2) throw new UnParsableHeaderException("Invalid property");
            if (!"q".equals(qualifierParts[0].trim())) throw new UnParsableHeaderException("Unrecoginsed property");
            try {
                qualifier = Double.parseDouble(qualifierParts[1].trim());
            }
            catch (NumberFormatException ex) {
                throw new UnParsableHeaderException("Number format excetpion.");
            }
            if (!(qualifier < 0.0) && !(qualifier > 1.0)) return new QLanguage(lastParts[0].trim(), "*", qualifier);
            throw new UnParsableHeaderException("Invalid qualifier range.");
        }
        if (langParts.length != 2) throw new UnParsableHeaderException("Unparsable language: " + types.trim() + ": " + langParts.length);
        if (langParts[0].contains(";")) {
            throw new UnParsableHeaderException("Semicolon before dash");
        }
        String[] lastParts = langParts[1].trim().split(";");
        if (lastParts.length == 1) {
            qualifier = 1.0;
            return new QLanguage(langParts[0].trim(), lastParts[0].trim(), qualifier);
        }
        if (lastParts.length != 2) throw new UnParsableHeaderException("Incorrect number of parts.");
        String[] qualifierParts = lastParts[1].trim().split("=");
        if (qualifierParts.length != 2) throw new UnParsableHeaderException("Invalid property");
        if (!"q".equals(qualifierParts[0].trim())) throw new UnParsableHeaderException("Unrecoginsed property");
        try {
            qualifier = Double.parseDouble(qualifierParts[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new UnParsableHeaderException("Number format excetpion.");
        }
        if (!(qualifier < 0.0) && !(qualifier > 1.0)) return new QLanguage(langParts[0].trim(), lastParts[0].trim(), qualifier);
        throw new UnParsableHeaderException("Invalid qualifier range.");
    }
}

