/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers;

import com.mattunderscore.http.headers.ContentTypeParser;
import com.mattunderscore.http.headers.HeaderFieldElement;
import com.mattunderscore.http.headers.Qualified;
import com.mattunderscore.http.headers.UnParsableHeaderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QContentType
implements HeaderFieldElement,
Qualified,
Cloneable {
    public static final QContentType TEXT_HTML = new QContentType("text", "html", null, 1.0);
    public static final QContentType APP_XHTML = new QContentType("application", "xhtml+xml", null, 1.0);
    public static final QContentType APP_RDF = new QContentType("application", "rdf+xml", null, 1.0);
    private static final int HASH_SEED = 13;
    private static final int HASH_MULT = 5;
    private static final String WILDCARD = "*";
    private final String type;
    private final String subType;
    private final Map<String, String> parameters;
    private final double qualifier;
    private String toString;

    public QContentType(String type, String subType, Map<String, String> parameters, double qualifier) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        if (subType == null) {
            throw new IllegalArgumentException("SubType must not be null.");
        }
        if (qualifier < 0.0 || qualifier > 1.0) {
            throw new IllegalArgumentException("Qualifier must be between 0.0 and 1.0");
        }
        this.type = type;
        this.subType = subType;
        this.parameters = parameters != null ? Collections.unmodifiableMap(new HashMap<String, String>(parameters)) : null;
        this.qualifier = qualifier;
    }

    public static List<QContentType> getRequestContentTypes(HttpServletRequest request) throws UnParsableHeaderException {
        Enumeration headerNames = request.getHeaderNames();
        ContentTypeParser parser = new ContentTypeParser();
        ArrayList<QContentType> types = new ArrayList<QContentType>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!parser.isCorrectHeader(headerName)) continue;
            String headers = request.getHeader(headerName);
            types.addAll(parser.parseAll(headers));
        }
        return types;
    }

    public String toString() {
        String toString = this.toString;
        if (toString != null) {
            return toString;
        }
        toString = this.type + "/" + this.subType + ";q=" + this.getQualifier();
        if (this.parameters != null) {
            for (String name : this.parameters.keySet()) {
                toString = toString + ";" + name + "=" + this.parameters.get(name);
            }
        }
        this.toString = toString;
        return toString;
    }

    @Override
    public final double getQualifier() {
        return this.qualifier;
    }

    public final boolean sameType(QContentType qct) {
        if (this.type.equals(qct.type) && this.subType.equals(qct.subType)) {
            return true;
        }
        if (this.type.equals(qct.type) && (WILDCARD.equals(this.subType) || WILDCARD.equals(qct.subType))) {
            return true;
        }
        if ((WILDCARD.equals(this.type) || WILDCARD.equals(qct.type)) && this.subType.equals(qct.subType)) {
            return true;
        }
        return !(!WILDCARD.equals(this.type) && !WILDCARD.equals(qct.type) || !WILDCARD.equals(this.subType) && !WILDCARD.equals(qct.subType));
    }

    public final boolean isAnySubType() {
        return WILDCARD.equals(this.subType);
    }

    public boolean isAnyType() {
        return WILDCARD.equals(this.type);
    }

    public int hashCode() {
        int hashCode = 13;
        hashCode = hashCode * 5 + this.type.hashCode();
        hashCode = hashCode * 5 + this.subType.hashCode();
        if (this.parameters != null) {
            for (String key : this.parameters.keySet()) {
                hashCode = hashCode * 5 + key.hashCode();
                hashCode = hashCode * 5 + this.parameters.get(key).hashCode();
            }
        }
        long temp = Double.doubleToLongBits(this.qualifier);
        hashCode = hashCode * 5 + (int)(temp ^ temp >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof QContentType) {
            QContentType contentType = (QContentType)object;
            if (!this.type.equals(contentType.type) || !this.subType.equals(contentType.subType) || this.qualifier != contentType.qualifier) {
                return false;
            }
            if (this.parameters == null) {
                if (contentType.parameters == null) {
                    return true;
                }
                return contentType.parameters.size() == 0;
            }
            if (contentType.parameters == null) {
                return this.parameters.size() == 0;
            }
            if (this.parameters.size() == contentType.parameters.size()) {
                Set<String> keys = this.parameters.keySet();
                for (String key : keys) {
                    String value1;
                    String value0 = this.parameters.get(key);
                    boolean objectsEqual = value0.equals(value1 = contentType.parameters.get(key));
                    if (objectsEqual) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Deprecated
    public QContentType clone() {
        try {
            QContentType newObject = (QContentType)super.clone();
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

