/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers;

import com.mattunderscore.http.headers.EncodingParser;
import com.mattunderscore.http.headers.HeaderFieldElement;
import com.mattunderscore.http.headers.Qualified;
import com.mattunderscore.http.headers.UnParsableHeaderException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QEncoding
implements Qualified,
HeaderFieldElement,
Cloneable {
    private static final int HASH_SEED = 11;
    private static final int HASH_MULT = 17;
    private static final String WILDCARD = "*";
    private final String encoding;
    private final double qualifier;
    private String toString;

    public QEncoding(String encoding, double qualifier) {
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding must not be null.");
        }
        if (qualifier < 0.0 || qualifier > 1.0) {
            throw new IllegalArgumentException("Qualifier must be between 0.0 and 1.0");
        }
        this.encoding = encoding;
        this.qualifier = qualifier;
    }

    public static List<QEncoding> getRequestEncodings(HttpServletRequest request) throws UnParsableHeaderException {
        Enumeration headerNames = request.getHeaderNames();
        EncodingParser parser = new EncodingParser();
        ArrayList<QEncoding> encodings = new ArrayList<QEncoding>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!parser.isCorrectHeader(headerName)) continue;
            String headerFieldValue = request.getHeader(headerName);
            encodings.addAll(parser.parseAll(headerFieldValue));
        }
        return encodings;
    }

    @Override
    public final double getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        String toString = this.toString;
        if (toString != null) {
            return toString;
        }
        this.toString = toString = this.encoding + ";q=" + this.qualifier;
        return toString;
    }

    public final boolean sameEncoding(QEncoding encodingObject) {
        if (encodingObject == null) {
            return false;
        }
        return this.encoding.equalsIgnoreCase(encodingObject.encoding) || this.encoding.equals(WILDCARD) || encodingObject.encoding.equals(WILDCARD);
    }

    public final boolean isAnyEncoding() {
        return WILDCARD.equals(this.encoding);
    }

    public int hashCode() {
        int hashCode = 11;
        hashCode = hashCode * 17 + this.encoding.hashCode();
        long temp = Double.doubleToLongBits(this.qualifier);
        hashCode = hashCode * 17 + (int)(temp ^ temp >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof QEncoding) {
            QEncoding encoding = (QEncoding)object;
            return this.encoding.equals(encoding.encoding) && this.qualifier == encoding.qualifier;
        }
        return false;
    }

    @Deprecated
    public QEncoding clone() {
        try {
            QEncoding newObject = (QEncoding)super.clone();
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

