/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers;

import com.mattunderscore.http.headers.HeaderFieldElement;
import com.mattunderscore.http.headers.LanguageParser;
import com.mattunderscore.http.headers.Qualified;
import com.mattunderscore.http.headers.UnParsableHeaderException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QLanguage
implements HeaderFieldElement,
Qualified,
Cloneable {
    private static final int HASH_SEED = 3;
    private static final int HASH_MULT = 7;
    private static final String WILDCARD = "*";
    private final String language;
    private final String subLanguage;
    private final double qualifier;
    private String toString;

    public QLanguage(String language, String subLanguage, double qualifier) {
        if (language == null) {
            throw new IllegalArgumentException("Language must not be null.");
        }
        if (subLanguage == null) {
            throw new IllegalArgumentException("Sublanguage must not be null.");
        }
        if (qualifier < 0.0 || qualifier > 1.0) {
            throw new IllegalArgumentException("Qualifier must be between 0.0 and 1.0");
        }
        this.language = language;
        this.subLanguage = subLanguage;
        this.qualifier = qualifier;
    }

    public static List<QLanguage> getRequestLanguages(HttpServletRequest request) throws UnParsableHeaderException {
        Enumeration headerNames = request.getHeaderNames();
        LanguageParser parser = new LanguageParser();
        ArrayList<QLanguage> types = new ArrayList<QLanguage>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!parser.isCorrectHeader(headerName)) continue;
            String headers = request.getHeader(headerName);
            types.addAll(parser.parseAll(headers));
        }
        return types;
    }

    public String toString() {
        String toString = this.toString;
        if (toString != null) {
            return toString;
        }
        if (WILDCARD.equals(this.subLanguage)) {
            this.toString = toString = this.language + ";q=" + this.qualifier;
            return toString;
        }
        this.toString = toString = this.language + "-" + this.subLanguage + ";q=" + this.qualifier;
        return toString;
    }

    @Override
    public final double getQualifier() {
        return this.qualifier;
    }

    public final boolean sameLangauge(QLanguage lang) {
        if (this.language.equals(lang.language) && this.subLanguage.equals(lang.subLanguage)) {
            return true;
        }
        if (this.language.equals(lang.language) && (WILDCARD.equals(this.subLanguage) || WILDCARD.equals(lang.subLanguage))) {
            return true;
        }
        return WILDCARD.equals(this.language) || WILDCARD.equals(lang.language);
    }

    public int hashCode() {
        int hashCode = 3;
        hashCode = hashCode * 7 + this.language.hashCode();
        hashCode = hashCode * 7 + this.subLanguage.hashCode();
        long temp = Double.doubleToLongBits(this.qualifier);
        hashCode = hashCode * 7 + (int)(temp ^ temp >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof QLanguage) {
            QLanguage qLangunage = (QLanguage)object;
            return this.language.equals(qLangunage.language) && this.subLanguage.equals(qLangunage.subLanguage) & this.qualifier == qLangunage.qualifier;
        }
        return false;
    }

    @Deprecated
    public QLanguage clone() {
        try {
            QLanguage newObject = (QLanguage)super.clone();
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

