/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent;

import com.mattunderscore.http.headers.useragent.UserAgent;
import com.mattunderscore.http.headers.useragent.details.UserAgentDetail;
import com.mattunderscore.http.headers.useragent.details.application.Bot;
import com.mattunderscore.http.headers.useragent.details.application.Browser;
import com.mattunderscore.http.headers.useragent.details.application.Compatible;
import com.mattunderscore.http.headers.useragent.details.application.Firefox;
import com.mattunderscore.http.headers.useragent.details.software.platform.Gecko;

public class UserAgentQuerier {
    private final UserAgent userAgent;

    public UserAgentQuerier(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public boolean isBot() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Bot)) continue;
            return true;
        }
        return false;
    }

    public boolean isBrowser() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Browser)) continue;
            return true;
        }
        return false;
    }

    public boolean isIE() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Browser)) continue;
            return detail.name().equals("Internet Explorer");
        }
        return false;
    }

    public boolean isFirefox() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Firefox)) continue;
            return true;
        }
        return false;
    }

    public boolean isChrome() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Browser) || detail.name().equals("Safari")) continue;
            return detail.name().equals("Chrome");
        }
        return false;
    }

    public boolean isOpera() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Browser)) continue;
            return detail.name().equals("Opera");
        }
        return false;
    }

    public boolean isSafari() {
        boolean claimsSafari = false;
        boolean claimsChrome = false;
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Browser)) continue;
            if (detail.name().equals("Safari")) {
                claimsSafari = true;
                continue;
            }
            if (!detail.name().equals("Chrome")) continue;
            claimsChrome = true;
        }
        return claimsSafari && !claimsChrome;
    }

    public boolean likeSafari() {
        boolean claimsSafari = false;
        boolean claimsChrome = false;
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Browser)) continue;
            if (detail.name().equals("Safari")) {
                claimsSafari = true;
                continue;
            }
            if (!detail.name().equals("Chrome")) continue;
            claimsChrome = true;
        }
        return claimsSafari && claimsChrome;
    }

    public boolean likeGecko() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Gecko)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatible() {
        for (UserAgentDetail detail : this.userAgent.details()) {
            if (!(detail instanceof Compatible)) continue;
            return true;
        }
        return false;
    }
}

