/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.application.EncryptionStrength;
import com.mattunderscore.http.headers.useragent.details.hardware.Architecture;
import com.mattunderscore.http.headers.useragent.details.software.platform.Linux;
import com.mattunderscore.http.headers.useragent.details.software.platform.OSPlatform;
import com.mattunderscore.http.headers.useragent.parser.DesktopBrowserParser;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;

class AndroidPlatformParser {
    AndroidPlatformParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String remainingHeader = state.getRemaining();
        while (!remainingHeader.equals("")) {
            String oldHeader = remainingHeader;
            if (remainingHeader == "") {
                return state;
            }
            if (remainingHeader.startsWith("Android")) {
                String version = ParsingUtils.nextElement(remainingHeader.substring(8));
                state.addDetail(new OSPlatform("Android", version));
                remainingHeader = remainingHeader.substring(8 + version.length());
                state.setRemaining(remainingHeader);
            } else if (remainingHeader.startsWith("U")) {
                state.addDetail(new EncryptionStrength("USA"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.equals("I")) {
                state.addDetail(new EncryptionStrength("International"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.startsWith("N")) {
                state.addDetail(new EncryptionStrength("None"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.startsWith("Linux")) {
                String arch = ParsingUtils.nextElement(remainingHeader = remainingHeader.substring(6));
                if (arch.equals("x86_64")) {
                    state.addDetail(new Architecture(arch));
                    state.addDetail(new Linux(arch));
                    remainingHeader = remainingHeader.substring(6);
                } else if (arch.equals("i686")) {
                    state.addDetail(new Architecture(arch));
                    state.addDetail(new Linux(arch));
                    remainingHeader = remainingHeader.substring(4);
                } else {
                    if (arch.equals("x86")) {
                        state.addDetail(new Architecture(arch));
                        remainingHeader = remainingHeader.substring(3);
                    }
                    state.addDetail(new Linux());
                }
            }
            if (remainingHeader.startsWith(";")) {
                remainingHeader = remainingHeader.substring(1);
            } else {
                if (remainingHeader.startsWith(")")) {
                    state.setRemaining(remainingHeader);
                    DesktopBrowserParser.parse(state);
                    return state;
                }
                if (oldHeader.equals(remainingHeader)) {
                    int nextElement = ParsingUtils.nextElementStart(remainingHeader);
                    if (nextElement == 0) {
                        remainingHeader = remainingHeader.substring(1);
                    } else if (nextElement != -1) {
                        remainingHeader = remainingHeader.substring(nextElement);
                    } else {
                        return state;
                    }
                }
            }
            remainingHeader = remainingHeader.trim();
        }
        return state;
    }
}

