/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.application.EncryptionStrength;
import com.mattunderscore.http.headers.useragent.details.hardware.BlackBerry;
import com.mattunderscore.http.headers.useragent.details.hardware.BlackBerryVendorID;
import com.mattunderscore.http.headers.useragent.details.software.platform.BlackBerryConfiguration;
import com.mattunderscore.http.headers.useragent.details.software.platform.BlackBerryOS;
import com.mattunderscore.http.headers.useragent.details.software.platform.BlackBerryProfile;
import com.mattunderscore.http.headers.useragent.parser.DesktopBrowserParser;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;

class BlackBerryPlatformParser {
    BlackBerryPlatformParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String remainingHeader = state.getRemaining();
        while (!remainingHeader.equals("")) {
            String oldHeader = remainingHeader;
            if (remainingHeader.startsWith("BlackBerry")) {
                int modelStart = remainingHeader.indexOf(47);
                int berryEnd = remainingHeader.indexOf(59);
                if (modelStart != -1) {
                    String model;
                    if (berryEnd != -1 && berryEnd < modelStart) {
                        modelStart = remainingHeader.indexOf(32);
                        if (modelStart != -1) {
                            if (modelStart < berryEnd) {
                                state.setBlackBerry(true);
                                model = ParsingUtils.nextElement(remainingHeader.substring(11));
                                state.addDetail(new BlackBerry(model));
                                remainingHeader = remainingHeader.substring(modelStart);
                            } else {
                                state.setBlackBerry(true);
                                remainingHeader = remainingHeader.substring(berryEnd);
                            }
                        }
                        state.setRemaining(remainingHeader.trim());
                        continue;
                    }
                    model = remainingHeader.substring(10, modelStart);
                    state.addDetail(new BlackBerry(model));
                    String version = ParsingUtils.nextElement(remainingHeader.substring(modelStart + 1));
                    state.addDetail(new BlackBerryOS(version));
                    remainingHeader = remainingHeader.substring(modelStart + 1 + version.length());
                    state.setBlackBerry(true);
                }
            } else if (remainingHeader.startsWith("Profile")) {
                if (state.isBlackBerry() && (remainingHeader = remainingHeader.substring(8)).startsWith("MIDP")) {
                    String version = ParsingUtils.nextElement(remainingHeader.substring(5));
                    state.addDetail(new BlackBerryProfile("MIDP", version));
                    remainingHeader = remainingHeader.substring(5 + version.length());
                }
            } else if (remainingHeader.startsWith("Configuration")) {
                if (state.isBlackBerry() && (remainingHeader = remainingHeader.substring(14)).startsWith("CLDC")) {
                    String version = ParsingUtils.nextElement(remainingHeader.substring(5));
                    state.addDetail(new BlackBerryConfiguration("CLDC", version));
                    remainingHeader = remainingHeader.substring(5 + version.length());
                }
            } else if (remainingHeader.startsWith("VendorID")) {
                if (state.isBlackBerry()) {
                    String vendor = ParsingUtils.nextElement(remainingHeader.substring(9));
                    state.addDetail(new BlackBerryVendorID(vendor));
                    remainingHeader = remainingHeader.substring(9 + vendor.length());
                }
            } else if (remainingHeader.startsWith("U")) {
                state.addDetail(new EncryptionStrength("USA"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.equals("I")) {
                state.addDetail(new EncryptionStrength("International"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.startsWith("N")) {
                state.addDetail(new EncryptionStrength("None"));
                remainingHeader = remainingHeader.substring(1);
            }
            if (remainingHeader.startsWith(";")) {
                remainingHeader = remainingHeader.substring(1);
            } else {
                if (remainingHeader.startsWith(")")) {
                    state.setRemaining(remainingHeader);
                    DesktopBrowserParser.parse(state);
                    return state;
                }
                if (oldHeader.equals(remainingHeader)) {
                    int nextElement = ParsingUtils.nextElementStart(remainingHeader);
                    if (nextElement == 0) {
                        remainingHeader = remainingHeader.substring(1);
                    } else if (nextElement != -1) {
                        remainingHeader = remainingHeader.substring(nextElement);
                    } else {
                        return state;
                    }
                }
            }
            remainingHeader = remainingHeader.trim();
        }
        return state;
    }
}

