/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.application.Bot;
import com.mattunderscore.http.headers.useragent.details.application.ContactInformation;
import com.mattunderscore.http.headers.useragent.details.application.GoogleBot;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;

class BotParser {
    BotParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String version;
        String remainingHeader = state.getRemaining();
        if (remainingHeader.startsWith("YandexBot")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(10));
            state.addDetail(new Bot("YandexBot", version));
            remainingHeader = remainingHeader.substring(10 + version.length());
        } else if (remainingHeader.startsWith("bingbot")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(10));
            state.addDetail(new Bot("bingbot", version));
            remainingHeader = remainingHeader.substring(10 + version.length());
        } else if (remainingHeader.startsWith("Googlebot")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(10));
            state.addDetail(new GoogleBot("Googlebot", version));
            remainingHeader = remainingHeader.substring(10 + version.length());
        } else if (remainingHeader.startsWith("+")) {
            String info = ParsingUtils.nextElement(remainingHeader.substring(1));
            state.addDetail(new ContactInformation(info));
            remainingHeader = remainingHeader.substring(1 + info.length());
        }
        if (remainingHeader.startsWith("Googlebot")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(10));
            state.addDetail(new GoogleBot("Googlebot", version));
            remainingHeader = remainingHeader.substring(10 + version.length()).trim();
            ParsingUtils.contactInformation(state);
        } else if (remainingHeader.startsWith("Googlebot-Image")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(10));
            state.addDetail(new GoogleBot("Googlebot-Image", version));
            remainingHeader = remainingHeader.substring(10 + version.length()).trim();
            ParsingUtils.contactInformation(state);
        } else if (remainingHeader.startsWith("btbot")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(6));
            state.addDetail(new Bot("btbot", version));
            remainingHeader = remainingHeader.substring(6 + version.length()).trim();
            ParsingUtils.contactInformation(state);
        } else if (remainingHeader.startsWith("semanticdiscovery")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(18));
            state.addDetail(new Bot("semanticdiscovery", version));
            remainingHeader = remainingHeader.substring(18 + version.length()).trim();
            ParsingUtils.contactInformation(state);
        } else if (remainingHeader.startsWith("msnbot")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(7));
            state.addDetail(new Bot("msnbot", version));
            remainingHeader = remainingHeader.substring(7 + version.length()).trim();
            ParsingUtils.contactInformation(state);
        } else if (remainingHeader.startsWith("WhatWeb")) {
            version = ParsingUtils.nextElement(remainingHeader.substring(8));
            state.addDetail(new Bot("WhatWeb", version));
            remainingHeader = remainingHeader.substring(8 + version.length()).trim();
            ParsingUtils.contactInformation(state);
        } else if (remainingHeader.startsWith("PagesInventory")) {
            state.addDetail(new Bot("PagesInventory"));
            remainingHeader = remainingHeader.substring(14).trim();
        } else if (remainingHeader.startsWith("AppEngine-Google")) {
            state.addDetail(new Bot("AppEngine-Google"));
            remainingHeader = remainingHeader.substring(16).trim();
        } else if (remainingHeader.startsWith("Morfeus Fucking Scanner")) {
            state.addDetail(new Bot("Morfeus Fucking Scanner"));
            remainingHeader = remainingHeader.substring(23);
        } else if (remainingHeader.startsWith("AdnormCrawler")) {
            String url = ParsingUtils.nextElement(remainingHeader.substring(14));
            state.addDetail(new Bot("AdnormCrawler"));
            state.addDetail(new ContactInformation(url));
            remainingHeader = remainingHeader.substring(14 + url.length()).trim();
        } else if (remainingHeader.startsWith("ia_archiver")) {
            state.addDetail(new Bot("ia_archiver"));
            remainingHeader = remainingHeader.substring(11).trim();
        } else if (remainingHeader.startsWith("ZmEu")) {
            state.addDetail(new Bot("ZmEu"));
            remainingHeader = remainingHeader.substring(4).trim();
        } else if (remainingHeader.startsWith("nutch")) {
            state.addDetail(new Bot("Nutch"));
            remainingHeader = remainingHeader.substring(5).trim();
        } else {
            String nextToken = ParsingUtils.nextElement(remainingHeader.substring(0));
            if (nextToken.contains("bot")) {
                state.addDetail(new Bot(nextToken));
                remainingHeader = remainingHeader.substring(nextToken.length()).trim();
            } else if (nextToken.contains("Bot")) {
                state.addDetail(new Bot(nextToken));
                remainingHeader = remainingHeader.substring(nextToken.length()).trim();
            } else if (nextToken.contains("BOT")) {
                state.addDetail(new Bot(nextToken));
                remainingHeader = remainingHeader.substring(nextToken.length()).trim();
            }
        }
        state.setRemaining(remainingHeader);
        return state;
    }
}

