/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.application.Browser;
import com.mattunderscore.http.headers.useragent.details.application.Firefox;
import com.mattunderscore.http.headers.useragent.details.application.LikeFirefox;
import com.mattunderscore.http.headers.useragent.details.application.Opera;
import com.mattunderscore.http.headers.useragent.details.application.Safari;
import com.mattunderscore.http.headers.useragent.details.application.SafariBased;
import com.mattunderscore.http.headers.useragent.details.software.platform.BlackBerryOS;
import com.mattunderscore.http.headers.useragent.details.software.platform.Gecko;
import com.mattunderscore.http.headers.useragent.details.software.platform.LayoutEngine;
import com.mattunderscore.http.headers.useragent.details.software.platform.LikeGecko;
import com.mattunderscore.http.headers.useragent.details.software.platform.Presto;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;

class DesktopBrowserParser {
    DesktopBrowserParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String remainingHeader = state.getRemaining();
        while (!remainingHeader.equals("")) {
            String buildNumber;
            String version;
            String oldHeader = remainingHeader;
            if (remainingHeader.startsWith("AppleWebKit")) {
                version = ParsingUtils.nextElement(remainingHeader.substring(12));
                state.addDetail(new LayoutEngine("AppleWebKit", version));
                remainingHeader = remainingHeader.substring(12 + version.length());
            } else if (remainingHeader.startsWith("KHTML")) {
                if (remainingHeader.substring(5, 6).equals("/")) {
                    String version2 = ParsingUtils.nextElement(remainingHeader.substring(6));
                    state.addDetail(new LayoutEngine("KHTML", version2));
                    remainingHeader = remainingHeader.substring(6 + version2.length());
                } else {
                    state.addDetail(new LayoutEngine("KHTML", "like"));
                    remainingHeader = remainingHeader.substring(6);
                }
            } else if (remainingHeader.startsWith("like")) {
                if ((remainingHeader = remainingHeader.substring(5)).startsWith("Gecko")) {
                    state.addDetail(new LikeGecko());
                    remainingHeader = remainingHeader.substring(5);
                } else if (remainingHeader.startsWith("Firefox")) {
                    String version3 = ParsingUtils.nextElement(remainingHeader.substring(8));
                    state.addDetail(new LikeFirefox(version3));
                    remainingHeader = remainingHeader.substring(8 + version3.length());
                }
            } else if (remainingHeader.startsWith("Gecko")) {
                String trail = ParsingUtils.nextElement(remainingHeader.substring(6));
                String rv = state.getValue("rv");
                if (rv != null) {
                    state.addDetail(new Gecko(rv, trail));
                    remainingHeader = remainingHeader.substring(6 + trail.length());
                } else {
                    state.addDetail(new Gecko());
                    remainingHeader = remainingHeader.substring(6);
                }
            } else if (remainingHeader.startsWith("Presto")) {
                String version4 = ParsingUtils.nextElement(remainingHeader.substring(7));
                state.addDetail(new Presto(version4));
                remainingHeader = remainingHeader.substring(7 + version4.length());
            }
            if (remainingHeader.startsWith("Chrome")) {
                version = ParsingUtils.nextElement(remainingHeader.substring(7));
                state.addDetail(new Browser("Chrome", version));
                remainingHeader = remainingHeader.substring(7 + version.length());
                if (remainingHeader.startsWith(" Safari")) {
                    buildNumber = ParsingUtils.nextElement(remainingHeader.substring(8));
                    state.addDetail(new SafariBased(buildNumber));
                    remainingHeader = remainingHeader.substring(8 + buildNumber.length());
                }
            } else if (remainingHeader.startsWith("Opera")) {
                version = ParsingUtils.nextElement(remainingHeader.substring(6));
                if (!version.equals("9.80")) {
                    state.addDetail(new Opera(version));
                    remainingHeader = remainingHeader.substring(6 + version.length());
                    state.setOperaSet(true);
                } else {
                    state.setOperaClaim(version);
                    remainingHeader = remainingHeader.substring(6 + version.length());
                }
            } else if (remainingHeader.startsWith("Firefox")) {
                version = ParsingUtils.nextElement(remainingHeader.substring(8));
                state.addDetail(new Firefox(version));
                remainingHeader = remainingHeader.substring(8 + version.length());
            } else if (remainingHeader.startsWith("Safari")) {
                if (state.isBlackBerry()) {
                    String buildNumber2 = ParsingUtils.nextElement(remainingHeader.substring(7));
                    state.addDetail(new SafariBased(buildNumber2));
                    remainingHeader = remainingHeader.substring(7 + buildNumber2.length());
                } else {
                    version = state.getValue("Version");
                    buildNumber = ParsingUtils.nextElement(remainingHeader.substring(7));
                    if (version != null) {
                        state.addDetail(new Safari(version, buildNumber));
                    } else {
                        state.addDetail(new SafariBased(buildNumber));
                    }
                    remainingHeader = remainingHeader.substring(7 + buildNumber.length());
                }
            } else if (remainingHeader.startsWith("Version")) {
                version = ParsingUtils.nextElement(remainingHeader.substring(8));
                if (state.getOperaClaim() != null) {
                    state.addDetail(new Opera(version, state.getOperaClaim()));
                    remainingHeader = remainingHeader.substring(8 + version.length());
                    state.setOperaSet(true);
                } else if (state.isBlackBerry()) {
                    state.addDetail(new BlackBerryOS(version));
                    remainingHeader = remainingHeader.substring(8 + version.length());
                } else {
                    state.addKeyValuePair("Version", version);
                    remainingHeader = remainingHeader.substring(8 + version.length());
                }
            }
            if (oldHeader.equals(remainingHeader)) {
                int nextElement = ParsingUtils.nextElementStart(remainingHeader);
                if (nextElement == 0) {
                    remainingHeader = remainingHeader.substring(1);
                } else if (nextElement != -1) {
                    remainingHeader = remainingHeader.substring(nextElement);
                } else {
                    return state;
                }
            }
            remainingHeader = remainingHeader.trim();
        }
        state.setRemaining(remainingHeader);
        return state;
    }
}

