/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.application.Browser;
import com.mattunderscore.http.headers.useragent.details.application.Compatible;
import com.mattunderscore.http.headers.useragent.details.application.ContactInformation;
import com.mattunderscore.http.headers.useragent.details.application.EncryptionStrength;
import com.mattunderscore.http.headers.useragent.details.application.GoogleBot;
import com.mattunderscore.http.headers.useragent.details.application.IE;
import com.mattunderscore.http.headers.useragent.details.hardware.Architecture;
import com.mattunderscore.http.headers.useragent.details.software.platform.Trident;
import com.mattunderscore.http.headers.useragent.details.software.platform.WindowSystem;
import com.mattunderscore.http.headers.useragent.parser.DesktopBrowserParser;
import com.mattunderscore.http.headers.useragent.parser.OSParser;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;

class GenericPlatformParser {
    GenericPlatformParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String remainingHeader = state.getRemaining();
        while (!remainingHeader.equals("")) {
            String oldHeader = remainingHeader;
            if (remainingHeader == "") {
                return state;
            }
            if (remainingHeader.startsWith("X11")) {
                state.addDetail(new WindowSystem("X11"));
                remainingHeader = remainingHeader.substring(3);
            } else if (remainingHeader.startsWith("compatible")) {
                state.addDetail(new Compatible());
                remainingHeader = remainingHeader.substring(10);
            } else if (remainingHeader.startsWith("MSIE")) {
                String version = ParsingUtils.nextElement(remainingHeader.substring(5));
                state.addDetail(new IE(version));
                remainingHeader = remainingHeader.substring(5 + version.length());
            } else if (remainingHeader.startsWith("Trident")) {
                String version = ParsingUtils.nextElement(remainingHeader.substring(8));
                state.addDetail(new Trident(version));
                remainingHeader = remainingHeader.substring(8 + version.length());
            } else if (remainingHeader.startsWith("Win64")) {
                state.addDetail(new Architecture("x64"));
                remainingHeader = remainingHeader.substring(5);
            } else if (remainingHeader.startsWith("x64")) {
                state.addDetail(new Architecture("x64"));
                remainingHeader = remainingHeader.substring(3);
            } else if (remainingHeader.startsWith("Win32")) {
                state.addDetail(new Architecture("x86"));
                remainingHeader = remainingHeader.substring(5);
            } else if (remainingHeader.startsWith("i686")) {
                state.addDetail(new Architecture("i686"));
                remainingHeader = remainingHeader.substring(4);
            } else if (remainingHeader.startsWith("Konqueror")) {
                state.addDetail(new Browser("Konqueror"));
                String version = ParsingUtils.nextElement(remainingHeader.substring(10));
                remainingHeader = remainingHeader.substring(10 + version.length());
            } else if (remainingHeader.startsWith("U")) {
                state.addDetail(new EncryptionStrength("USA"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.equals("I")) {
                state.addDetail(new EncryptionStrength("International"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.startsWith("N")) {
                state.addDetail(new EncryptionStrength("None"));
                remainingHeader = remainingHeader.substring(1);
            } else if (remainingHeader.startsWith("rv:")) {
                String version = ParsingUtils.nextElement(remainingHeader.substring(3));
                remainingHeader = remainingHeader.substring(3 + version.length());
                state.addKeyValuePair("rv", version);
            } else if (remainingHeader.startsWith("Googlebot")) {
                String version = ParsingUtils.nextElement(remainingHeader.substring(10));
                state.addDetail(new GoogleBot("Googlebot", version));
                remainingHeader = remainingHeader.substring(10 + version.length());
            } else if (remainingHeader.startsWith("+")) {
                String info = ParsingUtils.nextElement(remainingHeader.substring(1));
                state.addDetail(new ContactInformation(info));
                remainingHeader = remainingHeader.substring(1 + info.length());
            } else {
                state.setRemaining(remainingHeader);
                OSParser.parse(state);
                remainingHeader = state.getRemaining();
            }
            if (remainingHeader.startsWith(";")) {
                remainingHeader = remainingHeader.substring(1);
            } else {
                if (remainingHeader.startsWith(")")) {
                    state.setRemaining(remainingHeader);
                    DesktopBrowserParser.parse(state);
                    return state;
                }
                if (oldHeader.equals(remainingHeader)) {
                    int nextElement = ParsingUtils.nextElementStart(remainingHeader);
                    if (nextElement == 0) {
                        remainingHeader = remainingHeader.substring(1);
                    } else if (nextElement != -1) {
                        remainingHeader = remainingHeader.substring(nextElement);
                    } else {
                        return state;
                    }
                }
            }
            remainingHeader = remainingHeader.trim();
        }
        return state;
    }
}

