/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.application.EncryptionStrength;
import com.mattunderscore.http.headers.useragent.details.hardware.IPad;
import com.mattunderscore.http.headers.useragent.details.hardware.IPhone;
import com.mattunderscore.http.headers.useragent.details.hardware.IPod;
import com.mattunderscore.http.headers.useragent.details.software.platform.AppleMobileFirmware;
import com.mattunderscore.http.headers.useragent.details.software.platform.IOS;
import com.mattunderscore.http.headers.useragent.details.software.platform.IPhoneSimulator;
import com.mattunderscore.http.headers.useragent.details.software.platform.MacOSX;
import com.mattunderscore.http.headers.useragent.parser.IOSBrowserParser;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;

class IOSPlatformParser {
    IOSPlatformParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String header = state.getRemaining();
        header = header.trim();
        while (!header.equals("")) {
            String version;
            String oldHeader = header;
            if (header.startsWith("CPU OS")) {
                String xVersion = ParsingUtils.nextElement(header.substring(7));
                version = IOSPlatformParser.iOSVersion(xVersion);
                header = header.substring(7 + xVersion.length());
                state.addDetail(new IOS(version));
            } else if (header.startsWith("CPU iPhone OS")) {
                String xVersion = ParsingUtils.nextElement(header.substring(14));
                version = IOSPlatformParser.iOSVersion(xVersion);
                header = header.substring(14 + xVersion.length());
                state.addDetail(new IOS(version));
            } else if (header.startsWith("iPad")) {
                state.setIPad(true);
                state.addDetail(new IPad());
                header = header.substring(4);
            } else if (header.startsWith("iPod")) {
                state.setIPod(true);
                state.addDetail(new IPod());
                header = header.substring(4);
            } else if (header.startsWith("iPhone Simulator")) {
                state.setIPhoneSimulator(true);
                state.addDetail(new IPhoneSimulator());
                header = header.substring(16);
            } else if (header.startsWith("iPhone")) {
                state.setIPhone(true);
                state.addDetail(new IPhone());
                header = header.substring(6);
            } else if (header.startsWith("like Mac OS X")) {
                state.addDetail(new MacOSX("like"));
                header = header.substring(13);
            } else if (header.startsWith("Mobile")) {
                if (state.isIPad() || state.isIPhone() || state.isIPod() || state.isIPhoneSimulator()) {
                    String version2 = ParsingUtils.nextElement(header.substring(7));
                    state.addDetail(new AppleMobileFirmware(version2));
                    header = header.substring(7 + version2.length());
                } else {
                    header = header.substring(6);
                }
            } else if (header.startsWith("U")) {
                state.addDetail(new EncryptionStrength("USA"));
                header = header.substring(1);
            } else if (header.equals("I")) {
                state.addDetail(new EncryptionStrength("International"));
                header = header.substring(1);
            } else if (header.startsWith("N")) {
                state.addDetail(new EncryptionStrength("None"));
                header = header.substring(1);
            }
            if (header.startsWith(")")) {
                state.setRemaining(header.substring(1));
                IOSBrowserParser.parse(state);
                header = state.getRemaining();
                continue;
            }
            if (!oldHeader.equals(header)) continue;
            int nextElement = ParsingUtils.nextElementStart(header);
            if (nextElement == 0) {
                header = header.substring(1).trim();
                continue;
            }
            if (nextElement != -1) {
                header = header.substring(nextElement).trim();
                continue;
            }
            return state;
        }
        state.setRemaining(header);
        return state;
    }

    private static String iOSVersion(String version) {
        String rVersion = "";
        while (true) {
            if ("".equals(version)) {
                return rVersion;
            }
            int next = version.indexOf("_");
            if (next == -1) break;
            rVersion = rVersion + version.substring(0, next) + ".";
            version = version.substring(next + 1);
        }
        rVersion = rVersion + version;
        return rVersion;
    }
}

