/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.application.Browser;
import com.mattunderscore.http.headers.useragent.details.application.GoogleBot;
import com.mattunderscore.http.headers.useragent.details.application.MozillaBasedProduct;
import com.mattunderscore.http.headers.useragent.details.application.Opera;
import com.mattunderscore.http.headers.useragent.details.hardware.BlackBerry;
import com.mattunderscore.http.headers.useragent.details.software.platform.BlackBerryOS;
import com.mattunderscore.http.headers.useragent.details.software.platform.Java;
import com.mattunderscore.http.headers.useragent.parser.BlackBerryPlatformParser;
import com.mattunderscore.http.headers.useragent.parser.BotParser;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;
import com.mattunderscore.http.headers.useragent.parser.PlatformParser;

class InitialTokenParser {
    InitialTokenParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String header = state.getRemaining();
        if (header.startsWith("Mozilla")) {
            String version = ParsingUtils.nextElement(header.substring(8));
            state.addDetail(new MozillaBasedProduct(version));
            if (header.length() >= 10 + version.length()) {
                if ((header = header.substring(8 + version.length()).trim()).charAt(0) == '(') {
                    header = header.substring(1);
                }
            } else {
                header = header.substring(8 + version.length());
            }
        } else if (header.startsWith("Opera")) {
            String version = ParsingUtils.nextElement(header.substring(6));
            if (!version.equals("9.80")) {
                state.addDetail(new Opera(version));
                header = header.substring(8 + version.length());
                state.setOperaSet(true);
            } else {
                state.setOperaClaim(version);
                header = header.substring(8 + version.length());
            }
        } else if (header.startsWith("BlackBerry")) {
            int modelStart = header.indexOf(47);
            int berryEnd = header.indexOf(59);
            if (modelStart != -1 && berryEnd != -1 && berryEnd < modelStart) {
                modelStart = header.indexOf(32);
                if (modelStart != -1) {
                    if (modelStart < berryEnd) {
                        state.setBlackBerry(true);
                        String model = ParsingUtils.nextElement(header.substring(11));
                        state.addDetail(new BlackBerry(model));
                        header = header.substring(modelStart);
                    } else {
                        state.setBlackBerry(true);
                        header = header.substring(berryEnd);
                    }
                }
                state.setRemaining(header.trim());
                return state;
            }
            String model = header.substring(10, modelStart);
            state.addDetail(new BlackBerry(model));
            String version = ParsingUtils.nextElement(header.substring(modelStart + 1));
            state.addDetail(new BlackBerryOS(version));
            header = header.substring(modelStart + 1 + version.length());
            state.setBlackBerry(true);
            state.setRemaining(header);
            BlackBerryPlatformParser.parse(state);
        } else if (header.startsWith("Googlebot")) {
            String version = ParsingUtils.nextElement(header.substring(10));
            state.addDetail(new GoogleBot("Googlebot", version));
            header = header.substring(10 + version.length());
            state.setRemaining(header);
            ParsingUtils.contactInformation(state);
        } else if (header.startsWith("Wget")) {
            String version = ParsingUtils.nextElement(header.substring(5));
            state.addDetail(new Browser("Wget", version));
            header = header.substring(5 + version.length());
        } else if (header.startsWith("Java")) {
            String version = ParsingUtils.nextElement(header.substring(5));
            state.addDetail(new Java(version));
            header = header.substring(5 + version.length());
        } else {
            BotParser.parse(state);
        }
        state.setRemaining(header);
        if (!header.equals("")) {
            PlatformParser.parse(state);
        }
        return state;
    }
}

