/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.details.hardware.Architecture;
import com.mattunderscore.http.headers.useragent.details.software.platform.Linux;
import com.mattunderscore.http.headers.useragent.details.software.platform.MacOSX;
import com.mattunderscore.http.headers.useragent.details.software.platform.Machintosh;
import com.mattunderscore.http.headers.useragent.details.software.platform.OSPlatform;
import com.mattunderscore.http.headers.useragent.details.software.platform.Windows;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;
import com.mattunderscore.http.headers.useragent.parser.ParsingUtils;

class OSParser {
    OSParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String remainingHeader = state.getRemaining();
        if (remainingHeader.startsWith("Machintosh")) {
            state.addDetail(new Machintosh());
            remainingHeader = remainingHeader.substring(10);
        } else if (remainingHeader.startsWith("Windows NT")) {
            String version = ParsingUtils.nextElement(remainingHeader.substring(11));
            state.addDetail(new Windows("Windows NT", version));
            remainingHeader = remainingHeader.substring(11 + version.length());
        } else if (remainingHeader.startsWith("WinNT")) {
            String version = ParsingUtils.nextElement(remainingHeader.substring(6));
            state.addDetail(new Windows("Windows NT", version));
            remainingHeader = remainingHeader.substring(6 + version.length());
        } else if (remainingHeader.startsWith("Win95")) {
            state.addDetail(new OSPlatform("Windows 95"));
            remainingHeader = remainingHeader.substring(5);
        } else if (remainingHeader.startsWith("Windows 95")) {
            state.addDetail(new OSPlatform("Windows 95"));
            remainingHeader = remainingHeader.substring(10);
        } else if (remainingHeader.startsWith("Win98")) {
            state.addDetail(new OSPlatform("Windows 98"));
            remainingHeader = remainingHeader.substring(10);
        } else if (remainingHeader.startsWith("Windows 98; Win 9x 4.90")) {
            state.addDetail(new Windows("Windows 98", "", "Windows Millennium Edition (Windows Me)"));
            remainingHeader = remainingHeader.substring(23);
        } else if (remainingHeader.startsWith("Windows 98")) {
            state.addDetail(new OSPlatform("Windows 98"));
            remainingHeader = remainingHeader.substring(10);
        } else if (remainingHeader.startsWith("like Mac OS X")) {
            state.addDetail(new MacOSX("like"));
            remainingHeader = remainingHeader.substring(13);
        } else if (remainingHeader.startsWith("Mac OS X")) {
            String version = ParsingUtils.nextElement(remainingHeader.substring(9));
            state.addDetail(new MacOSX(version));
            remainingHeader = remainingHeader.substring(9 + version.length());
        } else if (remainingHeader.startsWith("Linux")) {
            String arch = ParsingUtils.nextElement(remainingHeader = remainingHeader.substring(6));
            if (arch.equals("x86_64")) {
                state.addDetail(new Architecture(arch));
                state.addDetail(new Linux(arch));
                remainingHeader = remainingHeader.substring(6);
            } else if (arch.equals("i686")) {
                state.addDetail(new Architecture(arch));
                state.addDetail(new Linux(arch));
                remainingHeader = remainingHeader.substring(4);
            } else {
                if (arch.equals("x86")) {
                    state.addDetail(new Architecture(arch));
                    remainingHeader = remainingHeader.substring(3);
                }
                state.addDetail(new Linux());
            }
        }
        state.setRemaining(remainingHeader);
        return state;
    }
}

