/*
 * Decompiled with CFR 0.152.
 */
package com.mattunderscore.http.headers.useragent.parser;

import com.mattunderscore.http.headers.useragent.parser.AndroidPlatformParser;
import com.mattunderscore.http.headers.useragent.parser.BlackBerryPlatformParser;
import com.mattunderscore.http.headers.useragent.parser.GenericPlatformParser;
import com.mattunderscore.http.headers.useragent.parser.IOSPlatformParser;
import com.mattunderscore.http.headers.useragent.parser.ParsingState;

class PlatformParser {
    PlatformParser() {
    }

    public static ParsingState parse(ParsingState state) {
        String header = state.getRemaining();
        String initialElement = PlatformParser.nextPlatformElement(header);
        if (initialElement.startsWith("iPod")) {
            IOSPlatformParser.parse(state);
        } else if (initialElement.startsWith("iPad")) {
            IOSPlatformParser.parse(state);
        } else if (initialElement.startsWith("iPhone")) {
            IOSPlatformParser.parse(state);
        } else if (initialElement.startsWith("BlackBerry")) {
            BlackBerryPlatformParser.parse(state);
        } else if (initialElement.startsWith("Android")) {
            AndroidPlatformParser.parse(state);
        } else {
            GenericPlatformParser.parse(state);
        }
        return state;
    }

    private static String nextPlatformElement(String header) {
        int endToken = header.indexOf(59);
        int endPlatform = header.indexOf(41);
        int next = -1;
        if (endToken != -1) {
            next = endToken;
        }
        if (endPlatform != -1 && endPlatform < next) {
            next = endPlatform;
        }
        return header.substring(0, next + 2);
    }
}

