/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.extensibility.initializers;

import com.microsoft.applicationinsights.common.CommonUtils;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebTelemetryInitializerBase;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;

public class WebSyntheticRequestTelemetryInitializer
extends WebTelemetryInitializerBase {
    static final String SYNTHETIC_SOURCE_NAME = "Application Insights Availability Monitoring";
    static final String SYNTHETIC_TEST_RUN_ID = "SyntheticTest-RunId";
    static final String SYNTHETIC_TEST_LOCATION = "SyntheticTest-Location";
    static final String SYNTHETIC_TEST_SOURCE = "SyntheticTest-Source";
    static final String SYNTHETIC_TEST_TEST_NAME = "SyntheticTest-TestName";
    static final String SYNTHETIC_TEST_SESSION_ID = "SyntheticTest-SessionId";
    static final String SYNTHETIC_TEST_USER_ID = "SyntheticTest-UserId";
    static final String SYNTHETIC_TEST_OPERATION_ID = "SyntheticTest-OperationId";

    @Override
    protected void onInitializeTelemetry(Telemetry telemetry) {
        RequestTelemetryContext telemetryContext = ThreadContext.getRequestTelemetryContext();
        if (telemetryContext == null) {
            return;
        }
        HttpServletRequest request = telemetryContext.getHttpServletRequest();
        if (request == null) {
            return;
        }
        String syntheticSourceHeader = request.getHeader(SYNTHETIC_TEST_SOURCE);
        if (CommonUtils.isNullOrEmpty((String)syntheticSourceHeader)) {
            this.handlePossibleGSMSyntheticRequest(telemetry, request);
        } else {
            this.handleCommonSyntheticRequest(syntheticSourceHeader, telemetry, request);
        }
    }

    private void handlePossibleGSMSyntheticRequest(Telemetry telemetry, HttpServletRequest request) {
        String userId;
        String sessionId;
        String gsmSyntheticTestRunId = request.getHeader(SYNTHETIC_TEST_RUN_ID);
        if (CommonUtils.isNullOrEmpty((String)gsmSyntheticTestRunId)) {
            return;
        }
        String syntheticSource = telemetry.getContext().getOperation().getSyntheticSource();
        if (CommonUtils.isNullOrEmpty((String)syntheticSource)) {
            telemetry.getContext().getOperation().setSyntheticSource(SYNTHETIC_SOURCE_NAME);
        }
        if (CommonUtils.isNullOrEmpty((String)(sessionId = telemetry.getContext().getSession().getId()))) {
            telemetry.getContext().getSession().setId(gsmSyntheticTestRunId);
        }
        if (CommonUtils.isNullOrEmpty((String)(userId = telemetry.getContext().getUser().getId()))) {
            String header = request.getHeader(SYNTHETIC_TEST_LOCATION);
            telemetry.getContext().getUser().setId(header);
        }
    }

    private void handleCommonSyntheticRequest(String syntheticSourceHeader, Telemetry telemetry, HttpServletRequest request) {
        String operationId;
        String sessionId;
        String userId;
        String syntheticSource = telemetry.getContext().getOperation().getSyntheticSource();
        if (CommonUtils.isNullOrEmpty((String)syntheticSource)) {
            telemetry.getContext().getOperation().setSyntheticSource(syntheticSourceHeader);
        }
        if (CommonUtils.isNullOrEmpty((String)(userId = telemetry.getContext().getUser().getId()))) {
            String header = request.getHeader(SYNTHETIC_TEST_USER_ID);
            telemetry.getContext().getUser().setId(header);
        }
        if (CommonUtils.isNullOrEmpty((String)(sessionId = telemetry.getContext().getSession().getId()))) {
            String header = request.getHeader(SYNTHETIC_TEST_SESSION_ID);
            telemetry.getContext().getSession().setId(header);
        }
        if (CommonUtils.isNullOrEmpty((String)(operationId = telemetry.getContext().getOperation().getId()))) {
            String header = request.getHeader(SYNTHETIC_TEST_OPERATION_ID);
            telemetry.getContext().getOperation().setId(header);
        }
        this.putInProperties(telemetry, request, SYNTHETIC_TEST_TEST_NAME, SYNTHETIC_TEST_RUN_ID, SYNTHETIC_TEST_LOCATION);
    }

    private void putInProperties(Telemetry telemetry, HttpServletRequest request, String ... headers) {
        ConcurrentMap properties = telemetry.getContext().getProperties();
        for (String header : headers) {
            String headerValue = request.getHeader(header);
            if (headerValue == null) continue;
            properties.put(header, headerValue);
        }
    }
}

