/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.messagesecurity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.messagesecurity.JWEHeader;
import com.microsoft.azure.keyvault.messagesecurity.MessageSecurityHelper;
import java.io.IOException;
import java.util.Objects;

class JWEObject {
    private JWEHeader jweHeader;
    private String originalProtected;
    private String encryptedKey;
    private String iv;
    private String cipherText;
    private String tag;

    JWEObject(JWEHeader jweHeader, String encryptedKey, String iv, String cipherText, String tag) {
        this.jweHeader = jweHeader;
        this.encryptedKey = encryptedKey;
        this.iv = iv;
        this.cipherText = cipherText;
        this.tag = tag;
    }

    @JsonCreator
    JWEObject(@JsonProperty(value="protected") String jweHeaderB64, @JsonProperty(value="encrypted_key") String encryptedKey, @JsonProperty(value="iv") String iv, @JsonProperty(value="ciphertext") String cipherText, @JsonProperty(value="tag") String tag) throws Exception {
        this.jweHeader = JWEHeader.fromBase64String(jweHeaderB64);
        this.originalProtected = jweHeaderB64;
        this.encryptedKey = encryptedKey;
        this.iv = iv;
        this.cipherText = cipherText;
        this.tag = tag;
    }

    public boolean equals(JWEObject other) {
        return this.jweHeader.equals(other.jweHeader) && this.encryptedKey.equals(other.encryptedKey) && this.iv.equals(other.iv) && this.cipherText.equals(other.cipherText) && this.tag.equals(other.tag);
    }

    public int hashCode() {
        return Objects.hash(this.jweHeader, this.encryptedKey, this.iv, this.cipherText, this.tag);
    }

    public String serialize() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static JWEObject deserialize(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JWEObject)mapper.readValue(json, JWEObject.class);
    }

    public JWEHeader jweHeader() {
        return this.jweHeader;
    }

    @JsonProperty(value="protected")
    public String protectedB64() throws Exception {
        return MessageSecurityHelper.stringToBase64Url(this.jweHeader.serialize());
    }

    public String originalProtected() {
        return this.originalProtected;
    }

    @JsonProperty(value="encrypted_key")
    public String encryptedKey() {
        return this.encryptedKey;
    }

    @JsonProperty(value="iv")
    public String iv() {
        return this.iv;
    }

    @JsonProperty(value="ciphertext")
    public String cipherText() {
        return this.cipherText;
    }

    @JsonProperty(value="tag")
    public String tag() {
        return this.tag;
    }
}

