/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.OriginInner;
import com.microsoft.azure.management.cdn.implementation.OriginUpdateParametersInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class OriginsInner {
    private OriginsService service;
    private CdnManagementClientImpl client;

    public OriginsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (OriginsService)retrofit.create(OriginsService.class);
        this.client = client;
    }

    public PagedList<OriginInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<OriginInner>((Page)response.body()){

            public Page<OriginInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OriginsInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OriginInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName, ListOperationCallback<OriginInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName), (Func1)new Func1<String, Observable<ServiceResponse<Page<OriginInner>>>>(){

            public Observable<ServiceResponse<Page<OriginInner>>> call(String nextPageLink) {
                return OriginsInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OriginInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<Page<OriginInner>>, Page<OriginInner>>(){

            public Page<OriginInner> call(ServiceResponse<Page<OriginInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginInner>>> listByEndpointWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).concatMap((Func1)new Func1<ServiceResponse<Page<OriginInner>>, Observable<ServiceResponse<Page<OriginInner>>>>(){

            public Observable<ServiceResponse<Page<OriginInner>>> call(ServiceResponse<Page<OriginInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OriginsInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginInner>>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByEndpoint(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OriginInner>>>>(){

            public Observable<ServiceResponse<Page<OriginInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OriginsInner.this.listByEndpointDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OriginInner>> listByEndpointDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OriginInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public OriginInner get(String resourceGroupName, String profileName, String endpointName, String originName) {
        return (OriginInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName).toBlocking().single()).body());
    }

    public ServiceFuture<OriginInner> getAsync(String resourceGroupName, String profileName, String endpointName, String originName, ServiceCallback<OriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName), serviceCallback);
    }

    public Observable<OriginInner> getAsync(String resourceGroupName, String profileName, String endpointName, String originName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName).map((Func1)new Func1<ServiceResponse<OriginInner>, OriginInner>(){

            public OriginInner call(ServiceResponse<OriginInner> response) {
                return (OriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, endpointName, originName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginInner>>>(){

            public Observable<ServiceResponse<OriginInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OriginsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OriginInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OriginInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public OriginInner update(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties) {
        return (OriginInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName, originUpdateProperties).toBlocking().last()).body());
    }

    public ServiceFuture<OriginInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties, ServiceCallback<OriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName, originUpdateProperties), serviceCallback);
    }

    public Observable<OriginInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName, originUpdateProperties).map((Func1)new Func1<ServiceResponse<OriginInner>, OriginInner>(){

            public OriginInner call(ServiceResponse<OriginInner> response) {
                return (OriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originUpdateProperties);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, endpointName, originName, this.client.subscriptionId(), originUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OriginInner>(){}.getType());
    }

    public OriginInner beginUpdate(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties) {
        return (OriginInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName, originUpdateProperties).toBlocking().single()).body());
    }

    public ServiceFuture<OriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties, ServiceCallback<OriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName, originUpdateProperties), serviceCallback);
    }

    public Observable<OriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originName, originUpdateProperties).map((Func1)new Func1<ServiceResponse<OriginInner>, OriginInner>(){

            public OriginInner call(ServiceResponse<OriginInner> response) {
                return (OriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originName, OriginUpdateParametersInner originUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originUpdateProperties);
        return this.service.beginUpdate(resourceGroupName, profileName, endpointName, originName, this.client.subscriptionId(), originUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginInner>>>(){

            public Observable<ServiceResponse<OriginInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OriginsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OriginInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OriginInner>(){}.getType()).register(202, new TypeToken<OriginInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<OriginInner> listByEndpointNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OriginInner>((Page)response.body()){

            public Page<OriginInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OriginsInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OriginInner>> listByEndpointNextAsync(String nextPageLink, ServiceFuture<List<OriginInner>> serviceFuture, ListOperationCallback<OriginInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<OriginInner>>>>(){

            public Observable<ServiceResponse<Page<OriginInner>>> call(String nextPageLink) {
                return OriginsInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OriginInner>> listByEndpointNextAsync(String nextPageLink) {
        return this.listByEndpointNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<OriginInner>>, Page<OriginInner>>(){

            public Page<OriginInner> call(ServiceResponse<Page<OriginInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginInner>>> listByEndpointNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByEndpointNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<OriginInner>>, Observable<ServiceResponse<Page<OriginInner>>>>(){

            public Observable<ServiceResponse<Page<OriginInner>>> call(ServiceResponse<Page<OriginInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OriginsInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginInner>>> listByEndpointNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByEndpointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OriginInner>>>>(){

            public Observable<ServiceResponse<Page<OriginInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OriginsInner.this.listByEndpointNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OriginInner>> listByEndpointNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OriginInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface OriginsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Origins listByEndpoint"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins")
        public Observable<Response<ResponseBody>> listByEndpoint(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Origins get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Origins update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Body OriginUpdateParametersInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Origins beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Body OriginUpdateParametersInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Origins listByEndpointNext"})
        @GET
        public Observable<Response<ResponseBody>> listByEndpointNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

